/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.ReissueCertificateOrderRequestProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class ReissueCertificateOrderRequest
extends ProxyOnlyResource {
    private ReissueCertificateOrderRequestProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private ReissueCertificateOrderRequestProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public ReissueCertificateOrderRequest withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public Integer keySize() {
        return this.innerProperties() == null ? null : this.innerProperties().keySize();
    }

    public ReissueCertificateOrderRequest withKeySize(Integer keySize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReissueCertificateOrderRequestProperties();
        }
        this.innerProperties().withKeySize(keySize);
        return this;
    }

    public Integer delayExistingRevokeInHours() {
        return this.innerProperties() == null ? null : this.innerProperties().delayExistingRevokeInHours();
    }

    public ReissueCertificateOrderRequest withDelayExistingRevokeInHours(Integer delayExistingRevokeInHours) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReissueCertificateOrderRequestProperties();
        }
        this.innerProperties().withDelayExistingRevokeInHours(delayExistingRevokeInHours);
        return this;
    }

    public String csr() {
        return this.innerProperties() == null ? null : this.innerProperties().csr();
    }

    public ReissueCertificateOrderRequest withCsr(String csr) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReissueCertificateOrderRequestProperties();
        }
        this.innerProperties().withCsr(csr);
        return this;
    }

    public Boolean isPrivateKeyExternal() {
        return this.innerProperties() == null ? null : this.innerProperties().isPrivateKeyExternal();
    }

    public ReissueCertificateOrderRequest withIsPrivateKeyExternal(Boolean isPrivateKeyExternal) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReissueCertificateOrderRequestProperties();
        }
        this.innerProperties().withIsPrivateKeyExternal(isPrivateKeyExternal);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ReissueCertificateOrderRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ReissueCertificateOrderRequest)((Object)jsonReader.readObject(reader -> {
            ReissueCertificateOrderRequest deserializedReissueCertificateOrderRequest = new ReissueCertificateOrderRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedReissueCertificateOrderRequest.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedReissueCertificateOrderRequest.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedReissueCertificateOrderRequest.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedReissueCertificateOrderRequest.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedReissueCertificateOrderRequest.innerProperties = ReissueCertificateOrderRequestProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReissueCertificateOrderRequest;
        }));
    }
}

