/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.DaprComponent;
import java.io.IOException;
import java.util.List;

public final class Dapr
implements JsonSerializable<Dapr> {
    private Boolean enabled;
    private String appId;
    private Integer appPort;
    private List<DaprComponent> components;

    public Boolean enabled() {
        return this.enabled;
    }

    public Dapr withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String appId() {
        return this.appId;
    }

    public Dapr withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public Integer appPort() {
        return this.appPort;
    }

    public Dapr withAppPort(Integer appPort) {
        this.appPort = appPort;
        return this;
    }

    public List<DaprComponent> components() {
        return this.components;
    }

    public Dapr withComponents(List<DaprComponent> components) {
        this.components = components;
        return this;
    }

    public void validate() {
        if (this.components() != null) {
            this.components().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("appId", this.appId);
        jsonWriter.writeNumberField("appPort", (Number)this.appPort);
        jsonWriter.writeArrayField("components", this.components, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static Dapr fromJson(JsonReader jsonReader) throws IOException {
        return (Dapr)jsonReader.readObject(reader -> {
            Dapr deserializedDapr = new Dapr();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedDapr.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("appId".equals(fieldName)) {
                    deserializedDapr.appId = reader.getString();
                    continue;
                }
                if ("appPort".equals(fieldName)) {
                    deserializedDapr.appPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("components".equals(fieldName)) {
                    List components;
                    deserializedDapr.components = components = reader.readArray(reader1 -> DaprComponent.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDapr;
        });
    }
}

