/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.CsmDeploymentStatusProperties;
import com.azure.resourcemanager.appservice.models.DeploymentBuildStatus;
import com.azure.resourcemanager.appservice.models.ErrorEntity;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.util.List;

public final class CsmDeploymentStatus
extends ProxyOnlyResource {
    private CsmDeploymentStatusProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private CsmDeploymentStatusProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public CsmDeploymentStatus withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String deploymentId() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentId();
    }

    public CsmDeploymentStatus withDeploymentId(String deploymentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CsmDeploymentStatusProperties();
        }
        this.innerProperties().withDeploymentId(deploymentId);
        return this;
    }

    public DeploymentBuildStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public CsmDeploymentStatus withStatus(DeploymentBuildStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CsmDeploymentStatusProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public Integer numberOfInstancesInProgress() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfInstancesInProgress();
    }

    public CsmDeploymentStatus withNumberOfInstancesInProgress(Integer numberOfInstancesInProgress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CsmDeploymentStatusProperties();
        }
        this.innerProperties().withNumberOfInstancesInProgress(numberOfInstancesInProgress);
        return this;
    }

    public Integer numberOfInstancesSuccessful() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfInstancesSuccessful();
    }

    public CsmDeploymentStatus withNumberOfInstancesSuccessful(Integer numberOfInstancesSuccessful) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CsmDeploymentStatusProperties();
        }
        this.innerProperties().withNumberOfInstancesSuccessful(numberOfInstancesSuccessful);
        return this;
    }

    public Integer numberOfInstancesFailed() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfInstancesFailed();
    }

    public CsmDeploymentStatus withNumberOfInstancesFailed(Integer numberOfInstancesFailed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CsmDeploymentStatusProperties();
        }
        this.innerProperties().withNumberOfInstancesFailed(numberOfInstancesFailed);
        return this;
    }

    public List<String> failedInstancesLogs() {
        return this.innerProperties() == null ? null : this.innerProperties().failedInstancesLogs();
    }

    public CsmDeploymentStatus withFailedInstancesLogs(List<String> failedInstancesLogs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CsmDeploymentStatusProperties();
        }
        this.innerProperties().withFailedInstancesLogs(failedInstancesLogs);
        return this;
    }

    public List<ErrorEntity> errors() {
        return this.innerProperties() == null ? null : this.innerProperties().errors();
    }

    public CsmDeploymentStatus withErrors(List<ErrorEntity> errors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CsmDeploymentStatusProperties();
        }
        this.innerProperties().withErrors(errors);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CsmDeploymentStatus fromJson(JsonReader jsonReader) throws IOException {
        return (CsmDeploymentStatus)((Object)jsonReader.readObject(reader -> {
            CsmDeploymentStatus deserializedCsmDeploymentStatus = new CsmDeploymentStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCsmDeploymentStatus.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCsmDeploymentStatus.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCsmDeploymentStatus.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedCsmDeploymentStatus.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCsmDeploymentStatus.innerProperties = CsmDeploymentStatusProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCsmDeploymentStatus;
        }));
    }
}

