/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.VnetGatewayProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class VnetGatewayInner
extends ProxyOnlyResource {
    private VnetGatewayProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private VnetGatewayProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public VnetGatewayInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String vnetName() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetName();
    }

    public VnetGatewayInner withVnetName(String vnetName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetGatewayProperties();
        }
        this.innerProperties().withVnetName(vnetName);
        return this;
    }

    public String vpnPackageUri() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnPackageUri();
    }

    public VnetGatewayInner withVpnPackageUri(String vpnPackageUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetGatewayProperties();
        }
        this.innerProperties().withVpnPackageUri(vpnPackageUri);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VnetGatewayInner fromJson(JsonReader jsonReader) throws IOException {
        return (VnetGatewayInner)((Object)jsonReader.readObject(reader -> {
            VnetGatewayInner deserializedVnetGatewayInner = new VnetGatewayInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVnetGatewayInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVnetGatewayInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVnetGatewayInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedVnetGatewayInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVnetGatewayInner.innerProperties = VnetGatewayProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVnetGatewayInner;
        }));
    }
}

