/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.ProcessInfoProperties;
import com.azure.resourcemanager.appservice.fluent.models.ProcessModuleInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.ProcessThreadInfoInner;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ProcessInfoInner
extends ProxyOnlyResource {
    private ProcessInfoProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private ProcessInfoProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public ProcessInfoInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public Integer identifier() {
        return this.innerProperties() == null ? null : this.innerProperties().identifier();
    }

    public String deploymentName() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentName();
    }

    public ProcessInfoInner withDeploymentName(String deploymentName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withDeploymentName(deploymentName);
        return this;
    }

    public String href() {
        return this.innerProperties() == null ? null : this.innerProperties().href();
    }

    public ProcessInfoInner withHref(String href) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withHref(href);
        return this;
    }

    public String minidump() {
        return this.innerProperties() == null ? null : this.innerProperties().minidump();
    }

    public ProcessInfoInner withMinidump(String minidump) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withMinidump(minidump);
        return this;
    }

    public Boolean isProfileRunning() {
        return this.innerProperties() == null ? null : this.innerProperties().isProfileRunning();
    }

    public ProcessInfoInner withIsProfileRunning(Boolean isProfileRunning) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withIsProfileRunning(isProfileRunning);
        return this;
    }

    public Boolean isIisProfileRunning() {
        return this.innerProperties() == null ? null : this.innerProperties().isIisProfileRunning();
    }

    public ProcessInfoInner withIsIisProfileRunning(Boolean isIisProfileRunning) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withIsIisProfileRunning(isIisProfileRunning);
        return this;
    }

    public Double iisProfileTimeoutInSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().iisProfileTimeoutInSeconds();
    }

    public ProcessInfoInner withIisProfileTimeoutInSeconds(Double iisProfileTimeoutInSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withIisProfileTimeoutInSeconds(iisProfileTimeoutInSeconds);
        return this;
    }

    public String parent() {
        return this.innerProperties() == null ? null : this.innerProperties().parent();
    }

    public ProcessInfoInner withParent(String parent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withParent(parent);
        return this;
    }

    public List<String> children() {
        return this.innerProperties() == null ? null : this.innerProperties().children();
    }

    public ProcessInfoInner withChildren(List<String> children) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withChildren(children);
        return this;
    }

    public List<ProcessThreadInfoInner> threads() {
        return this.innerProperties() == null ? null : this.innerProperties().threads();
    }

    public ProcessInfoInner withThreads(List<ProcessThreadInfoInner> threads) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withThreads(threads);
        return this;
    }

    public List<String> openFileHandles() {
        return this.innerProperties() == null ? null : this.innerProperties().openFileHandles();
    }

    public ProcessInfoInner withOpenFileHandles(List<String> openFileHandles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withOpenFileHandles(openFileHandles);
        return this;
    }

    public List<ProcessModuleInfoInner> modules() {
        return this.innerProperties() == null ? null : this.innerProperties().modules();
    }

    public ProcessInfoInner withModules(List<ProcessModuleInfoInner> modules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withModules(modules);
        return this;
    }

    public String fileName() {
        return this.innerProperties() == null ? null : this.innerProperties().fileName();
    }

    public ProcessInfoInner withFileName(String fileName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withFileName(fileName);
        return this;
    }

    public String commandLine() {
        return this.innerProperties() == null ? null : this.innerProperties().commandLine();
    }

    public ProcessInfoInner withCommandLine(String commandLine) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withCommandLine(commandLine);
        return this;
    }

    public String username() {
        return this.innerProperties() == null ? null : this.innerProperties().username();
    }

    public ProcessInfoInner withUsername(String username) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withUsername(username);
        return this;
    }

    public Integer handleCount() {
        return this.innerProperties() == null ? null : this.innerProperties().handleCount();
    }

    public ProcessInfoInner withHandleCount(Integer handleCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withHandleCount(handleCount);
        return this;
    }

    public Integer moduleCount() {
        return this.innerProperties() == null ? null : this.innerProperties().moduleCount();
    }

    public ProcessInfoInner withModuleCount(Integer moduleCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withModuleCount(moduleCount);
        return this;
    }

    public Integer threadCount() {
        return this.innerProperties() == null ? null : this.innerProperties().threadCount();
    }

    public ProcessInfoInner withThreadCount(Integer threadCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withThreadCount(threadCount);
        return this;
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public ProcessInfoInner withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    public String totalCpuTime() {
        return this.innerProperties() == null ? null : this.innerProperties().totalCpuTime();
    }

    public ProcessInfoInner withTotalCpuTime(String totalCpuTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withTotalCpuTime(totalCpuTime);
        return this;
    }

    public String userCpuTime() {
        return this.innerProperties() == null ? null : this.innerProperties().userCpuTime();
    }

    public ProcessInfoInner withUserCpuTime(String userCpuTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withUserCpuTime(userCpuTime);
        return this;
    }

    public String privilegedCpuTime() {
        return this.innerProperties() == null ? null : this.innerProperties().privilegedCpuTime();
    }

    public ProcessInfoInner withPrivilegedCpuTime(String privilegedCpuTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withPrivilegedCpuTime(privilegedCpuTime);
        return this;
    }

    public Long workingSet() {
        return this.innerProperties() == null ? null : this.innerProperties().workingSet();
    }

    public ProcessInfoInner withWorkingSet(Long workingSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withWorkingSet(workingSet);
        return this;
    }

    public Long peakWorkingSet() {
        return this.innerProperties() == null ? null : this.innerProperties().peakWorkingSet();
    }

    public ProcessInfoInner withPeakWorkingSet(Long peakWorkingSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withPeakWorkingSet(peakWorkingSet);
        return this;
    }

    public Long privateMemory() {
        return this.innerProperties() == null ? null : this.innerProperties().privateMemory();
    }

    public ProcessInfoInner withPrivateMemory(Long privateMemory) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withPrivateMemory(privateMemory);
        return this;
    }

    public Long virtualMemory() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMemory();
    }

    public ProcessInfoInner withVirtualMemory(Long virtualMemory) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withVirtualMemory(virtualMemory);
        return this;
    }

    public Long peakVirtualMemory() {
        return this.innerProperties() == null ? null : this.innerProperties().peakVirtualMemory();
    }

    public ProcessInfoInner withPeakVirtualMemory(Long peakVirtualMemory) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withPeakVirtualMemory(peakVirtualMemory);
        return this;
    }

    public Long pagedSystemMemory() {
        return this.innerProperties() == null ? null : this.innerProperties().pagedSystemMemory();
    }

    public ProcessInfoInner withPagedSystemMemory(Long pagedSystemMemory) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withPagedSystemMemory(pagedSystemMemory);
        return this;
    }

    public Long nonPagedSystemMemory() {
        return this.innerProperties() == null ? null : this.innerProperties().nonPagedSystemMemory();
    }

    public ProcessInfoInner withNonPagedSystemMemory(Long nonPagedSystemMemory) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withNonPagedSystemMemory(nonPagedSystemMemory);
        return this;
    }

    public Long pagedMemory() {
        return this.innerProperties() == null ? null : this.innerProperties().pagedMemory();
    }

    public ProcessInfoInner withPagedMemory(Long pagedMemory) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withPagedMemory(pagedMemory);
        return this;
    }

    public Long peakPagedMemory() {
        return this.innerProperties() == null ? null : this.innerProperties().peakPagedMemory();
    }

    public ProcessInfoInner withPeakPagedMemory(Long peakPagedMemory) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withPeakPagedMemory(peakPagedMemory);
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.innerProperties() == null ? null : this.innerProperties().timestamp();
    }

    public ProcessInfoInner withTimestamp(OffsetDateTime timestamp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withTimestamp(timestamp);
        return this;
    }

    public Map<String, String> environmentVariables() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentVariables();
    }

    public ProcessInfoInner withEnvironmentVariables(Map<String, String> environmentVariables) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withEnvironmentVariables(environmentVariables);
        return this;
    }

    public Boolean isScmSite() {
        return this.innerProperties() == null ? null : this.innerProperties().isScmSite();
    }

    public ProcessInfoInner withIsScmSite(Boolean isScmSite) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withIsScmSite(isScmSite);
        return this;
    }

    public Boolean isWebjob() {
        return this.innerProperties() == null ? null : this.innerProperties().isWebjob();
    }

    public ProcessInfoInner withIsWebjob(Boolean isWebjob) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withIsWebjob(isWebjob);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ProcessInfoInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessInfoProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ProcessInfoInner fromJson(JsonReader jsonReader) throws IOException {
        return (ProcessInfoInner)((Object)jsonReader.readObject(reader -> {
            ProcessInfoInner deserializedProcessInfoInner = new ProcessInfoInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedProcessInfoInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedProcessInfoInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedProcessInfoInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedProcessInfoInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedProcessInfoInner.innerProperties = ProcessInfoProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProcessInfoInner;
        }));
    }
}

