/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.AseRegionProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.util.List;

public final class AseRegionInner
extends ProxyOnlyResource {
    private AseRegionProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private AseRegionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public AseRegionInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public Boolean standard() {
        return this.innerProperties() == null ? null : this.innerProperties().standard();
    }

    public Boolean dedicatedHost() {
        return this.innerProperties() == null ? null : this.innerProperties().dedicatedHost();
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public List<String> availableSku() {
        return this.innerProperties() == null ? null : this.innerProperties().availableSku();
    }

    public AseRegionInner withAvailableSku(List<String> availableSku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AseRegionProperties();
        }
        this.innerProperties().withAvailableSku(availableSku);
        return this;
    }

    public List<String> availableOS() {
        return this.innerProperties() == null ? null : this.innerProperties().availableOS();
    }

    public AseRegionInner withAvailableOS(List<String> availableOS) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AseRegionProperties();
        }
        this.innerProperties().withAvailableOS(availableOS);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AseRegionInner fromJson(JsonReader jsonReader) throws IOException {
        return (AseRegionInner)((Object)jsonReader.readObject(reader -> {
            AseRegionInner deserializedAseRegionInner = new AseRegionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAseRegionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAseRegionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAseRegionInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedAseRegionInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAseRegionInner.innerProperties = AseRegionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAseRegionInner;
        }));
    }
}

