// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.VnetValidationTestFailureProperties;
import java.io.IOException;

/**
 * A class that describes a test that failed during NSG and UDR validation.
 */
@Fluent
public final class VnetValidationTestFailure extends ProxyOnlyResource {
    /*
     * VnetValidationTestFailure resource specific properties
     */
    private VnetValidationTestFailureProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of VnetValidationTestFailure class.
     */
    public VnetValidationTestFailure() {
    }

    /**
     * Get the innerProperties property: VnetValidationTestFailure resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private VnetValidationTestFailureProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public VnetValidationTestFailure withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the testName property: The name of the test that failed.
     * 
     * @return the testName value.
     */
    public String testName() {
        return this.innerProperties() == null ? null : this.innerProperties().testName();
    }

    /**
     * Set the testName property: The name of the test that failed.
     * 
     * @param testName the testName value to set.
     * @return the VnetValidationTestFailure object itself.
     */
    public VnetValidationTestFailure withTestName(String testName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetValidationTestFailureProperties();
        }
        this.innerProperties().withTestName(testName);
        return this;
    }

    /**
     * Get the details property: The details of what caused the failure, e.g. the blocking rule name, etc.
     * 
     * @return the details value.
     */
    public String details() {
        return this.innerProperties() == null ? null : this.innerProperties().details();
    }

    /**
     * Set the details property: The details of what caused the failure, e.g. the blocking rule name, etc.
     * 
     * @param details the details value to set.
     * @return the VnetValidationTestFailure object itself.
     */
    public VnetValidationTestFailure withDetails(String details) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetValidationTestFailureProperties();
        }
        this.innerProperties().withDetails(details);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VnetValidationTestFailure from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VnetValidationTestFailure if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VnetValidationTestFailure.
     */
    public static VnetValidationTestFailure fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VnetValidationTestFailure deserializedVnetValidationTestFailure = new VnetValidationTestFailure();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedVnetValidationTestFailure.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedVnetValidationTestFailure.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVnetValidationTestFailure.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedVnetValidationTestFailure.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedVnetValidationTestFailure.innerProperties
                        = VnetValidationTestFailureProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVnetValidationTestFailure;
        });
    }
}
