// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.VnetParametersProperties;
import java.io.IOException;

/**
 * The required set of inputs to validate a VNET.
 */
@Fluent
public final class VnetParameters extends ProxyOnlyResource {
    /*
     * VnetParameters resource specific properties
     */
    private VnetParametersProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of VnetParameters class.
     */
    public VnetParameters() {
    }

    /**
     * Get the innerProperties property: VnetParameters resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private VnetParametersProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public VnetParameters withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the vnetResourceGroup property: The Resource Group of the VNET to be validated.
     * 
     * @return the vnetResourceGroup value.
     */
    public String vnetResourceGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetResourceGroup();
    }

    /**
     * Set the vnetResourceGroup property: The Resource Group of the VNET to be validated.
     * 
     * @param vnetResourceGroup the vnetResourceGroup value to set.
     * @return the VnetParameters object itself.
     */
    public VnetParameters withVnetResourceGroup(String vnetResourceGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetParametersProperties();
        }
        this.innerProperties().withVnetResourceGroup(vnetResourceGroup);
        return this;
    }

    /**
     * Get the vnetName property: The name of the VNET to be validated.
     * 
     * @return the vnetName value.
     */
    public String vnetName() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetName();
    }

    /**
     * Set the vnetName property: The name of the VNET to be validated.
     * 
     * @param vnetName the vnetName value to set.
     * @return the VnetParameters object itself.
     */
    public VnetParameters withVnetName(String vnetName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetParametersProperties();
        }
        this.innerProperties().withVnetName(vnetName);
        return this;
    }

    /**
     * Get the vnetSubnetName property: The subnet name to be validated.
     * 
     * @return the vnetSubnetName value.
     */
    public String vnetSubnetName() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetSubnetName();
    }

    /**
     * Set the vnetSubnetName property: The subnet name to be validated.
     * 
     * @param vnetSubnetName the vnetSubnetName value to set.
     * @return the VnetParameters object itself.
     */
    public VnetParameters withVnetSubnetName(String vnetSubnetName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetParametersProperties();
        }
        this.innerProperties().withVnetSubnetName(vnetSubnetName);
        return this;
    }

    /**
     * Get the subnetResourceId property: The ARM Resource ID of the subnet to validate.
     * 
     * @return the subnetResourceId value.
     */
    public String subnetResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetResourceId();
    }

    /**
     * Set the subnetResourceId property: The ARM Resource ID of the subnet to validate.
     * 
     * @param subnetResourceId the subnetResourceId value to set.
     * @return the VnetParameters object itself.
     */
    public VnetParameters withSubnetResourceId(String subnetResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetParametersProperties();
        }
        this.innerProperties().withSubnetResourceId(subnetResourceId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VnetParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VnetParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VnetParameters.
     */
    public static VnetParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VnetParameters deserializedVnetParameters = new VnetParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedVnetParameters.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedVnetParameters.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVnetParameters.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedVnetParameters.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedVnetParameters.innerProperties = VnetParametersProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVnetParameters;
        });
    }
}
