// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Options for retrieving the list of top level domain legal agreements.
 */
@Fluent
public final class TopLevelDomainAgreementOption implements JsonSerializable<TopLevelDomainAgreementOption> {
    /*
     * If <code>true</code>, then the list of agreements will include agreements for domain privacy as well; otherwise,
     * <code>false</code>.
     */
    private Boolean includePrivacy;

    /*
     * If <code>true</code>, then the list of agreements will include agreements for domain transfer as well; otherwise,
     * <code>false</code>.
     */
    private Boolean forTransfer;

    /**
     * Creates an instance of TopLevelDomainAgreementOption class.
     */
    public TopLevelDomainAgreementOption() {
    }

    /**
     * Get the includePrivacy property: If &lt;code&gt;true&lt;/code&gt;, then the list of agreements will include
     * agreements for domain privacy as well; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the includePrivacy value.
     */
    public Boolean includePrivacy() {
        return this.includePrivacy;
    }

    /**
     * Set the includePrivacy property: If &lt;code&gt;true&lt;/code&gt;, then the list of agreements will include
     * agreements for domain privacy as well; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param includePrivacy the includePrivacy value to set.
     * @return the TopLevelDomainAgreementOption object itself.
     */
    public TopLevelDomainAgreementOption withIncludePrivacy(Boolean includePrivacy) {
        this.includePrivacy = includePrivacy;
        return this;
    }

    /**
     * Get the forTransfer property: If &lt;code&gt;true&lt;/code&gt;, then the list of agreements will include
     * agreements for domain transfer as well; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the forTransfer value.
     */
    public Boolean forTransfer() {
        return this.forTransfer;
    }

    /**
     * Set the forTransfer property: If &lt;code&gt;true&lt;/code&gt;, then the list of agreements will include
     * agreements for domain transfer as well; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param forTransfer the forTransfer value to set.
     * @return the TopLevelDomainAgreementOption object itself.
     */
    public TopLevelDomainAgreementOption withForTransfer(Boolean forTransfer) {
        this.forTransfer = forTransfer;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("includePrivacy", this.includePrivacy);
        jsonWriter.writeBooleanField("forTransfer", this.forTransfer);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TopLevelDomainAgreementOption from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TopLevelDomainAgreementOption if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TopLevelDomainAgreementOption.
     */
    public static TopLevelDomainAgreementOption fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TopLevelDomainAgreementOption deserializedTopLevelDomainAgreementOption
                = new TopLevelDomainAgreementOption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("includePrivacy".equals(fieldName)) {
                    deserializedTopLevelDomainAgreementOption.includePrivacy
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("forTransfer".equals(fieldName)) {
                    deserializedTopLevelDomainAgreementOption.forTransfer = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTopLevelDomainAgreementOption;
        });
    }
}
