// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration settings of the token store.
 */
@Fluent
public final class TokenStore implements JsonSerializable<TokenStore> {
    /*
     * <code>true</code> to durably store platform-specific security tokens that are obtained during login flows;
     * otherwise, <code>false</code>.
     * The default is <code>false</code>.
     */
    private Boolean enabled;

    /*
     * The number of hours after session token expiration that a session token can be used to
     * call the token refresh API. The default is 72 hours.
     */
    private Double tokenRefreshExtensionHours;

    /*
     * The configuration settings of the storage of the tokens if a file system is used.
     */
    private FileSystemTokenStore fileSystem;

    /*
     * The configuration settings of the storage of the tokens if blob storage is used.
     */
    private BlobStorageTokenStore azureBlobStorage;

    /**
     * Creates an instance of TokenStore class.
     */
    public TokenStore() {
    }

    /**
     * Get the enabled property: &lt;code&gt;true&lt;/code&gt; to durably store platform-specific security tokens that
     * are obtained during login flows; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * The default is &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: &lt;code&gt;true&lt;/code&gt; to durably store platform-specific security tokens that
     * are obtained during login flows; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * The default is &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param enabled the enabled value to set.
     * @return the TokenStore object itself.
     */
    public TokenStore withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the tokenRefreshExtensionHours property: The number of hours after session token expiration that a session
     * token can be used to
     * call the token refresh API. The default is 72 hours.
     * 
     * @return the tokenRefreshExtensionHours value.
     */
    public Double tokenRefreshExtensionHours() {
        return this.tokenRefreshExtensionHours;
    }

    /**
     * Set the tokenRefreshExtensionHours property: The number of hours after session token expiration that a session
     * token can be used to
     * call the token refresh API. The default is 72 hours.
     * 
     * @param tokenRefreshExtensionHours the tokenRefreshExtensionHours value to set.
     * @return the TokenStore object itself.
     */
    public TokenStore withTokenRefreshExtensionHours(Double tokenRefreshExtensionHours) {
        this.tokenRefreshExtensionHours = tokenRefreshExtensionHours;
        return this;
    }

    /**
     * Get the fileSystem property: The configuration settings of the storage of the tokens if a file system is used.
     * 
     * @return the fileSystem value.
     */
    public FileSystemTokenStore fileSystem() {
        return this.fileSystem;
    }

    /**
     * Set the fileSystem property: The configuration settings of the storage of the tokens if a file system is used.
     * 
     * @param fileSystem the fileSystem value to set.
     * @return the TokenStore object itself.
     */
    public TokenStore withFileSystem(FileSystemTokenStore fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    /**
     * Get the azureBlobStorage property: The configuration settings of the storage of the tokens if blob storage is
     * used.
     * 
     * @return the azureBlobStorage value.
     */
    public BlobStorageTokenStore azureBlobStorage() {
        return this.azureBlobStorage;
    }

    /**
     * Set the azureBlobStorage property: The configuration settings of the storage of the tokens if blob storage is
     * used.
     * 
     * @param azureBlobStorage the azureBlobStorage value to set.
     * @return the TokenStore object itself.
     */
    public TokenStore withAzureBlobStorage(BlobStorageTokenStore azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (fileSystem() != null) {
            fileSystem().validate();
        }
        if (azureBlobStorage() != null) {
            azureBlobStorage().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeNumberField("tokenRefreshExtensionHours", this.tokenRefreshExtensionHours);
        jsonWriter.writeJsonField("fileSystem", this.fileSystem);
        jsonWriter.writeJsonField("azureBlobStorage", this.azureBlobStorage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TokenStore from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TokenStore if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the TokenStore.
     */
    public static TokenStore fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TokenStore deserializedTokenStore = new TokenStore();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedTokenStore.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("tokenRefreshExtensionHours".equals(fieldName)) {
                    deserializedTokenStore.tokenRefreshExtensionHours = reader.getNullable(JsonReader::getDouble);
                } else if ("fileSystem".equals(fieldName)) {
                    deserializedTokenStore.fileSystem = FileSystemTokenStore.fromJson(reader);
                } else if ("azureBlobStorage".equals(fieldName)) {
                    deserializedTokenStore.azureBlobStorage = BlobStorageTokenStore.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTokenStore;
        });
    }
}
