// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Function app resource requirements.
 */
@Fluent
public final class ResourceConfig implements JsonSerializable<ResourceConfig> {
    /*
     * Required CPU in cores, e.g. 0.5
     */
    private Double cpu;

    /*
     * Required memory, e.g. "1Gi"
     */
    private String memory;

    /**
     * Creates an instance of ResourceConfig class.
     */
    public ResourceConfig() {
    }

    /**
     * Get the cpu property: Required CPU in cores, e.g. 0.5.
     * 
     * @return the cpu value.
     */
    public Double cpu() {
        return this.cpu;
    }

    /**
     * Set the cpu property: Required CPU in cores, e.g. 0.5.
     * 
     * @param cpu the cpu value to set.
     * @return the ResourceConfig object itself.
     */
    public ResourceConfig withCpu(Double cpu) {
        this.cpu = cpu;
        return this;
    }

    /**
     * Get the memory property: Required memory, e.g. "1Gi".
     * 
     * @return the memory value.
     */
    public String memory() {
        return this.memory;
    }

    /**
     * Set the memory property: Required memory, e.g. "1Gi".
     * 
     * @param memory the memory value to set.
     * @return the ResourceConfig object itself.
     */
    public ResourceConfig withMemory(String memory) {
        this.memory = memory;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("cpu", this.cpu);
        jsonWriter.writeStringField("memory", this.memory);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceConfig if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceConfig.
     */
    public static ResourceConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceConfig deserializedResourceConfig = new ResourceConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cpu".equals(fieldName)) {
                    deserializedResourceConfig.cpu = reader.getNullable(JsonReader::getDouble);
                } else if ("memory".equals(fieldName)) {
                    deserializedResourceConfig.memory = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceConfig;
        });
    }
}
