// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * AuthenticationPolicy of type Open.
 */
@Fluent
public final class OpenAuthenticationAccessPolicies implements JsonSerializable<OpenAuthenticationAccessPolicies> {
    /*
     * Open authentication policies.
     */
    private Map<String, OpenAuthenticationAccessPolicy> policies;

    /**
     * Creates an instance of OpenAuthenticationAccessPolicies class.
     */
    public OpenAuthenticationAccessPolicies() {
    }

    /**
     * Get the policies property: Open authentication policies.
     * 
     * @return the policies value.
     */
    public Map<String, OpenAuthenticationAccessPolicy> policies() {
        return this.policies;
    }

    /**
     * Set the policies property: Open authentication policies.
     * 
     * @param policies the policies value to set.
     * @return the OpenAuthenticationAccessPolicies object itself.
     */
    public OpenAuthenticationAccessPolicies withPolicies(Map<String, OpenAuthenticationAccessPolicy> policies) {
        this.policies = policies;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (policies() != null) {
            policies().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("policies", this.policies, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenAuthenticationAccessPolicies from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenAuthenticationAccessPolicies if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OpenAuthenticationAccessPolicies.
     */
    public static OpenAuthenticationAccessPolicies fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenAuthenticationAccessPolicies deserializedOpenAuthenticationAccessPolicies
                = new OpenAuthenticationAccessPolicies();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("policies".equals(fieldName)) {
                    Map<String, OpenAuthenticationAccessPolicy> policies
                        = reader.readMap(reader1 -> OpenAuthenticationAccessPolicy.fromJson(reader1));
                    deserializedOpenAuthenticationAccessPolicies.policies = policies;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOpenAuthenticationAccessPolicies;
        });
    }
}
