// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Http logs configuration.
 */
@Fluent
public final class HttpLogsConfig implements JsonSerializable<HttpLogsConfig> {
    /*
     * Http logs to file system configuration.
     */
    private FileSystemHttpLogsConfig fileSystem;

    /*
     * Http logs to azure blob storage configuration.
     */
    private AzureBlobStorageHttpLogsConfig azureBlobStorage;

    /**
     * Creates an instance of HttpLogsConfig class.
     */
    public HttpLogsConfig() {
    }

    /**
     * Get the fileSystem property: Http logs to file system configuration.
     * 
     * @return the fileSystem value.
     */
    public FileSystemHttpLogsConfig fileSystem() {
        return this.fileSystem;
    }

    /**
     * Set the fileSystem property: Http logs to file system configuration.
     * 
     * @param fileSystem the fileSystem value to set.
     * @return the HttpLogsConfig object itself.
     */
    public HttpLogsConfig withFileSystem(FileSystemHttpLogsConfig fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    /**
     * Get the azureBlobStorage property: Http logs to azure blob storage configuration.
     * 
     * @return the azureBlobStorage value.
     */
    public AzureBlobStorageHttpLogsConfig azureBlobStorage() {
        return this.azureBlobStorage;
    }

    /**
     * Set the azureBlobStorage property: Http logs to azure blob storage configuration.
     * 
     * @param azureBlobStorage the azureBlobStorage value to set.
     * @return the HttpLogsConfig object itself.
     */
    public HttpLogsConfig withAzureBlobStorage(AzureBlobStorageHttpLogsConfig azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (fileSystem() != null) {
            fileSystem().validate();
        }
        if (azureBlobStorage() != null) {
            azureBlobStorage().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("fileSystem", this.fileSystem);
        jsonWriter.writeJsonField("azureBlobStorage", this.azureBlobStorage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HttpLogsConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HttpLogsConfig if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HttpLogsConfig.
     */
    public static HttpLogsConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpLogsConfig deserializedHttpLogsConfig = new HttpLogsConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("fileSystem".equals(fieldName)) {
                    deserializedHttpLogsConfig.fileSystem = FileSystemHttpLogsConfig.fromJson(reader);
                } else if ("azureBlobStorage".equals(fieldName)) {
                    deserializedHttpLogsConfig.azureBlobStorage = AzureBlobStorageHttpLogsConfig.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHttpLogsConfig;
        });
    }
}
