// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The GitHub action configuration.
 */
@Fluent
public final class GitHubActionConfiguration implements JsonSerializable<GitHubActionConfiguration> {
    /*
     * GitHub Action code configuration.
     */
    private GitHubActionCodeConfiguration codeConfiguration;

    /*
     * GitHub Action container configuration.
     */
    private GitHubActionContainerConfiguration containerConfiguration;

    /*
     * This will help determine the workflow configuration to select.
     */
    private Boolean isLinux;

    /*
     * Workflow option to determine whether the workflow file should be generated and written to the repository.
     */
    private Boolean generateWorkflowFile;

    /**
     * Creates an instance of GitHubActionConfiguration class.
     */
    public GitHubActionConfiguration() {
    }

    /**
     * Get the codeConfiguration property: GitHub Action code configuration.
     * 
     * @return the codeConfiguration value.
     */
    public GitHubActionCodeConfiguration codeConfiguration() {
        return this.codeConfiguration;
    }

    /**
     * Set the codeConfiguration property: GitHub Action code configuration.
     * 
     * @param codeConfiguration the codeConfiguration value to set.
     * @return the GitHubActionConfiguration object itself.
     */
    public GitHubActionConfiguration withCodeConfiguration(GitHubActionCodeConfiguration codeConfiguration) {
        this.codeConfiguration = codeConfiguration;
        return this;
    }

    /**
     * Get the containerConfiguration property: GitHub Action container configuration.
     * 
     * @return the containerConfiguration value.
     */
    public GitHubActionContainerConfiguration containerConfiguration() {
        return this.containerConfiguration;
    }

    /**
     * Set the containerConfiguration property: GitHub Action container configuration.
     * 
     * @param containerConfiguration the containerConfiguration value to set.
     * @return the GitHubActionConfiguration object itself.
     */
    public GitHubActionConfiguration
        withContainerConfiguration(GitHubActionContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        return this;
    }

    /**
     * Get the isLinux property: This will help determine the workflow configuration to select.
     * 
     * @return the isLinux value.
     */
    public Boolean isLinux() {
        return this.isLinux;
    }

    /**
     * Set the isLinux property: This will help determine the workflow configuration to select.
     * 
     * @param isLinux the isLinux value to set.
     * @return the GitHubActionConfiguration object itself.
     */
    public GitHubActionConfiguration withIsLinux(Boolean isLinux) {
        this.isLinux = isLinux;
        return this;
    }

    /**
     * Get the generateWorkflowFile property: Workflow option to determine whether the workflow file should be generated
     * and written to the repository.
     * 
     * @return the generateWorkflowFile value.
     */
    public Boolean generateWorkflowFile() {
        return this.generateWorkflowFile;
    }

    /**
     * Set the generateWorkflowFile property: Workflow option to determine whether the workflow file should be generated
     * and written to the repository.
     * 
     * @param generateWorkflowFile the generateWorkflowFile value to set.
     * @return the GitHubActionConfiguration object itself.
     */
    public GitHubActionConfiguration withGenerateWorkflowFile(Boolean generateWorkflowFile) {
        this.generateWorkflowFile = generateWorkflowFile;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (codeConfiguration() != null) {
            codeConfiguration().validate();
        }
        if (containerConfiguration() != null) {
            containerConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("codeConfiguration", this.codeConfiguration);
        jsonWriter.writeJsonField("containerConfiguration", this.containerConfiguration);
        jsonWriter.writeBooleanField("isLinux", this.isLinux);
        jsonWriter.writeBooleanField("generateWorkflowFile", this.generateWorkflowFile);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GitHubActionConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GitHubActionConfiguration if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GitHubActionConfiguration.
     */
    public static GitHubActionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GitHubActionConfiguration deserializedGitHubActionConfiguration = new GitHubActionConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("codeConfiguration".equals(fieldName)) {
                    deserializedGitHubActionConfiguration.codeConfiguration
                        = GitHubActionCodeConfiguration.fromJson(reader);
                } else if ("containerConfiguration".equals(fieldName)) {
                    deserializedGitHubActionConfiguration.containerConfiguration
                        = GitHubActionContainerConfiguration.fromJson(reader);
                } else if ("isLinux".equals(fieldName)) {
                    deserializedGitHubActionConfiguration.isLinux = reader.getNullable(JsonReader::getBoolean);
                } else if ("generateWorkflowFile".equals(fieldName)) {
                    deserializedGitHubActionConfiguration.generateWorkflowFile
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGitHubActionConfiguration;
        });
    }
}
