// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.DatabaseConnectionPatchRequestProperties;
import java.io.IOException;

/**
 * Static Site Database Connection Request Properties resource when patching.
 */
@Fluent
public final class DatabaseConnectionPatchRequest implements JsonSerializable<DatabaseConnectionPatchRequest> {
    /*
     * DatabaseConnectionPatchRequest resource specific properties
     */
    private DatabaseConnectionPatchRequestProperties innerProperties;

    /**
     * Creates an instance of DatabaseConnectionPatchRequest class.
     */
    public DatabaseConnectionPatchRequest() {
    }

    /**
     * Get the innerProperties property: DatabaseConnectionPatchRequest resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private DatabaseConnectionPatchRequestProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the resourceId property: The resource id of the database.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    /**
     * Set the resourceId property: The resource id of the database.
     * 
     * @param resourceId the resourceId value to set.
     * @return the DatabaseConnectionPatchRequest object itself.
     */
    public DatabaseConnectionPatchRequest withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseConnectionPatchRequestProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    /**
     * Get the connectionIdentity property: If present, the identity is used in conjunction with connection string to
     * connect to the database. Use of the system-assigned managed identity is indicated with the string
     * 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed
     * identity resource.
     * 
     * @return the connectionIdentity value.
     */
    public String connectionIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionIdentity();
    }

    /**
     * Set the connectionIdentity property: If present, the identity is used in conjunction with connection string to
     * connect to the database. Use of the system-assigned managed identity is indicated with the string
     * 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed
     * identity resource.
     * 
     * @param connectionIdentity the connectionIdentity value to set.
     * @return the DatabaseConnectionPatchRequest object itself.
     */
    public DatabaseConnectionPatchRequest withConnectionIdentity(String connectionIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseConnectionPatchRequestProperties();
        }
        this.innerProperties().withConnectionIdentity(connectionIdentity);
        return this;
    }

    /**
     * Get the connectionString property: The connection string to use to connect to the database.
     * 
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionString();
    }

    /**
     * Set the connectionString property: The connection string to use to connect to the database.
     * 
     * @param connectionString the connectionString value to set.
     * @return the DatabaseConnectionPatchRequest object itself.
     */
    public DatabaseConnectionPatchRequest withConnectionString(String connectionString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseConnectionPatchRequestProperties();
        }
        this.innerProperties().withConnectionString(connectionString);
        return this;
    }

    /**
     * Get the region property: The region of the database resource.
     * 
     * @return the region value.
     */
    public String region() {
        return this.innerProperties() == null ? null : this.innerProperties().region();
    }

    /**
     * Set the region property: The region of the database resource.
     * 
     * @param region the region value to set.
     * @return the DatabaseConnectionPatchRequest object itself.
     */
    public DatabaseConnectionPatchRequest withRegion(String region) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseConnectionPatchRequestProperties();
        }
        this.innerProperties().withRegion(region);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseConnectionPatchRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseConnectionPatchRequest if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DatabaseConnectionPatchRequest.
     */
    public static DatabaseConnectionPatchRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseConnectionPatchRequest deserializedDatabaseConnectionPatchRequest
                = new DatabaseConnectionPatchRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedDatabaseConnectionPatchRequest.innerProperties
                        = DatabaseConnectionPatchRequestProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseConnectionPatchRequest;
        });
    }
}
