// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Container App Dapr component metadata.
 */
@Fluent
public final class DaprMetadata implements JsonSerializable<DaprMetadata> {
    /*
     * Metadata property name.
     */
    private String name;

    /*
     * Metadata property value.
     */
    private String value;

    /*
     * Name of the Container App secret from which to pull the metadata property value.
     */
    private String secretRef;

    /**
     * Creates an instance of DaprMetadata class.
     */
    public DaprMetadata() {
    }

    /**
     * Get the name property: Metadata property name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Metadata property name.
     * 
     * @param name the name value to set.
     * @return the DaprMetadata object itself.
     */
    public DaprMetadata withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: Metadata property value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Metadata property value.
     * 
     * @param value the value value to set.
     * @return the DaprMetadata object itself.
     */
    public DaprMetadata withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the secretRef property: Name of the Container App secret from which to pull the metadata property value.
     * 
     * @return the secretRef value.
     */
    public String secretRef() {
        return this.secretRef;
    }

    /**
     * Set the secretRef property: Name of the Container App secret from which to pull the metadata property value.
     * 
     * @param secretRef the secretRef value to set.
     * @return the DaprMetadata object itself.
     */
    public DaprMetadata withSecretRef(String secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("secretRef", this.secretRef);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DaprMetadata from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DaprMetadata if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DaprMetadata.
     */
    public static DaprMetadata fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DaprMetadata deserializedDaprMetadata = new DaprMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedDaprMetadata.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedDaprMetadata.value = reader.getString();
                } else if ("secretRef".equals(fieldName)) {
                    deserializedDaprMetadata.secretRef = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDaprMetadata;
        });
    }
}
