// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

/**
 * This composes with ClientCertEnabled setting.
 * - ClientCertEnabled: false means ClientCert is ignored.
 * - ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
 * - ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or accepted.
 */
public enum ClientCertMode {
    /**
     * Enum value Required.
     */
    REQUIRED("Required"),

    /**
     * Enum value Optional.
     */
    OPTIONAL("Optional"),

    /**
     * Enum value OptionalInteractiveUser.
     */
    OPTIONAL_INTERACTIVE_USER("OptionalInteractiveUser");

    /**
     * The actual serialized value for a ClientCertMode instance.
     */
    private final String value;

    ClientCertMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ClientCertMode instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ClientCertMode object, or null if unable to parse.
     */
    public static ClientCertMode fromString(String value) {
        if (value == null) {
            return null;
        }
        ClientCertMode[] items = ClientCertMode.values();
        for (ClientCertMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
