// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * User credentials used for publishing activity.
 */
@Fluent
public final class UserInner extends ProxyOnlyResource {
    /*
     * User resource specific properties
     */
    private UserProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of UserInner class.
     */
    public UserInner() {
    }

    /**
     * Get the innerProperties property: User resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private UserProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public UserInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the publishingUsername property: Username used for publishing.
     * 
     * @return the publishingUsername value.
     */
    public String publishingUsername() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingUsername();
    }

    /**
     * Set the publishingUsername property: Username used for publishing.
     * 
     * @param publishingUsername the publishingUsername value to set.
     * @return the UserInner object itself.
     */
    public UserInner withPublishingUsername(String publishingUsername) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserProperties();
        }
        this.innerProperties().withPublishingUsername(publishingUsername);
        return this;
    }

    /**
     * Get the publishingPassword property: Password used for publishing.
     * 
     * @return the publishingPassword value.
     */
    public String publishingPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingPassword();
    }

    /**
     * Set the publishingPassword property: Password used for publishing.
     * 
     * @param publishingPassword the publishingPassword value to set.
     * @return the UserInner object itself.
     */
    public UserInner withPublishingPassword(String publishingPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserProperties();
        }
        this.innerProperties().withPublishingPassword(publishingPassword);
        return this;
    }

    /**
     * Get the publishingPasswordHash property: Password hash used for publishing.
     * 
     * @return the publishingPasswordHash value.
     */
    public String publishingPasswordHash() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingPasswordHash();
    }

    /**
     * Set the publishingPasswordHash property: Password hash used for publishing.
     * 
     * @param publishingPasswordHash the publishingPasswordHash value to set.
     * @return the UserInner object itself.
     */
    public UserInner withPublishingPasswordHash(String publishingPasswordHash) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserProperties();
        }
        this.innerProperties().withPublishingPasswordHash(publishingPasswordHash);
        return this;
    }

    /**
     * Get the publishingPasswordHashSalt property: Password hash salt used for publishing.
     * 
     * @return the publishingPasswordHashSalt value.
     */
    public String publishingPasswordHashSalt() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingPasswordHashSalt();
    }

    /**
     * Set the publishingPasswordHashSalt property: Password hash salt used for publishing.
     * 
     * @param publishingPasswordHashSalt the publishingPasswordHashSalt value to set.
     * @return the UserInner object itself.
     */
    public UserInner withPublishingPasswordHashSalt(String publishingPasswordHashSalt) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserProperties();
        }
        this.innerProperties().withPublishingPasswordHashSalt(publishingPasswordHashSalt);
        return this;
    }

    /**
     * Get the scmUri property: Url of SCM site.
     * 
     * @return the scmUri value.
     */
    public String scmUri() {
        return this.innerProperties() == null ? null : this.innerProperties().scmUri();
    }

    /**
     * Set the scmUri property: Url of SCM site.
     * 
     * @param scmUri the scmUri value to set.
     * @return the UserInner object itself.
     */
    public UserInner withScmUri(String scmUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserProperties();
        }
        this.innerProperties().withScmUri(scmUri);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserInner if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UserInner.
     */
    public static UserInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserInner deserializedUserInner = new UserInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedUserInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedUserInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedUserInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedUserInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedUserInner.innerProperties = UserProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserInner;
        });
    }
}
