// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * Geographical region.
 */
@Fluent
public final class GeoRegionInner extends ProxyOnlyResource {
    /*
     * GeoRegion resource specific properties
     */
    private GeoRegionProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of GeoRegionInner class.
     */
    public GeoRegionInner() {
    }

    /**
     * Get the innerProperties property: GeoRegion resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private GeoRegionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GeoRegionInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the description property: Region description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Get the displayName property: Display name for region.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Get the orgDomain property: Display name for region.
     * 
     * @return the orgDomain value.
     */
    public String orgDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().orgDomain();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GeoRegionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GeoRegionInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GeoRegionInner.
     */
    public static GeoRegionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GeoRegionInner deserializedGeoRegionInner = new GeoRegionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGeoRegionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGeoRegionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGeoRegionInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedGeoRegionInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedGeoRegionInner.innerProperties = GeoRegionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGeoRegionInner;
        });
    }
}
