// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Deployment resource specific properties.
 */
@Fluent
public final class DeploymentProperties implements JsonSerializable<DeploymentProperties> {
    /*
     * Deployment status.
     */
    private Integer status;

    /*
     * Details about deployment status.
     */
    private String message;

    /*
     * Who authored the deployment.
     */
    private String author;

    /*
     * Who performed the deployment.
     */
    private String deployer;

    /*
     * Author email.
     */
    private String authorEmail;

    /*
     * Start time.
     */
    private OffsetDateTime startTime;

    /*
     * End time.
     */
    private OffsetDateTime endTime;

    /*
     * True if deployment is currently active, false if completed and null if not started.
     */
    private Boolean active;

    /*
     * Details on deployment.
     */
    private String details;

    /**
     * Creates an instance of DeploymentProperties class.
     */
    public DeploymentProperties() {
    }

    /**
     * Get the status property: Deployment status.
     * 
     * @return the status value.
     */
    public Integer status() {
        return this.status;
    }

    /**
     * Set the status property: Deployment status.
     * 
     * @param status the status value to set.
     * @return the DeploymentProperties object itself.
     */
    public DeploymentProperties withStatus(Integer status) {
        this.status = status;
        return this;
    }

    /**
     * Get the message property: Details about deployment status.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Details about deployment status.
     * 
     * @param message the message value to set.
     * @return the DeploymentProperties object itself.
     */
    public DeploymentProperties withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the author property: Who authored the deployment.
     * 
     * @return the author value.
     */
    public String author() {
        return this.author;
    }

    /**
     * Set the author property: Who authored the deployment.
     * 
     * @param author the author value to set.
     * @return the DeploymentProperties object itself.
     */
    public DeploymentProperties withAuthor(String author) {
        this.author = author;
        return this;
    }

    /**
     * Get the deployer property: Who performed the deployment.
     * 
     * @return the deployer value.
     */
    public String deployer() {
        return this.deployer;
    }

    /**
     * Set the deployer property: Who performed the deployment.
     * 
     * @param deployer the deployer value to set.
     * @return the DeploymentProperties object itself.
     */
    public DeploymentProperties withDeployer(String deployer) {
        this.deployer = deployer;
        return this;
    }

    /**
     * Get the authorEmail property: Author email.
     * 
     * @return the authorEmail value.
     */
    public String authorEmail() {
        return this.authorEmail;
    }

    /**
     * Set the authorEmail property: Author email.
     * 
     * @param authorEmail the authorEmail value to set.
     * @return the DeploymentProperties object itself.
     */
    public DeploymentProperties withAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
        return this;
    }

    /**
     * Get the startTime property: Start time.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Start time.
     * 
     * @param startTime the startTime value to set.
     * @return the DeploymentProperties object itself.
     */
    public DeploymentProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: End time.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: End time.
     * 
     * @param endTime the endTime value to set.
     * @return the DeploymentProperties object itself.
     */
    public DeploymentProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the active property: True if deployment is currently active, false if completed and null if not started.
     * 
     * @return the active value.
     */
    public Boolean active() {
        return this.active;
    }

    /**
     * Set the active property: True if deployment is currently active, false if completed and null if not started.
     * 
     * @param active the active value to set.
     * @return the DeploymentProperties object itself.
     */
    public DeploymentProperties withActive(Boolean active) {
        this.active = active;
        return this;
    }

    /**
     * Get the details property: Details on deployment.
     * 
     * @return the details value.
     */
    public String details() {
        return this.details;
    }

    /**
     * Set the details property: Details on deployment.
     * 
     * @param details the details value to set.
     * @return the DeploymentProperties object itself.
     */
    public DeploymentProperties withDetails(String details) {
        this.details = details;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("status", this.status);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("author", this.author);
        jsonWriter.writeStringField("deployer", this.deployer);
        jsonWriter.writeStringField("author_email", this.authorEmail);
        jsonWriter.writeStringField("start_time",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("end_time",
            this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeBooleanField("active", this.active);
        jsonWriter.writeStringField("details", this.details);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentProperties.
     */
    public static DeploymentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentProperties deserializedDeploymentProperties = new DeploymentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedDeploymentProperties.status = reader.getNullable(JsonReader::getInt);
                } else if ("message".equals(fieldName)) {
                    deserializedDeploymentProperties.message = reader.getString();
                } else if ("author".equals(fieldName)) {
                    deserializedDeploymentProperties.author = reader.getString();
                } else if ("deployer".equals(fieldName)) {
                    deserializedDeploymentProperties.deployer = reader.getString();
                } else if ("author_email".equals(fieldName)) {
                    deserializedDeploymentProperties.authorEmail = reader.getString();
                } else if ("start_time".equals(fieldName)) {
                    deserializedDeploymentProperties.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("end_time".equals(fieldName)) {
                    deserializedDeploymentProperties.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("active".equals(fieldName)) {
                    deserializedDeploymentProperties.active = reader.getNullable(JsonReader::getBoolean);
                } else if ("details".equals(fieldName)) {
                    deserializedDeploymentProperties.details = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentProperties;
        });
    }
}
