/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.WorkflowHealth;
import com.azure.resourcemanager.appservice.models.WorkflowState;
import java.io.IOException;
import java.util.Map;

public final class WorkflowEnvelopeProperties
implements JsonSerializable<WorkflowEnvelopeProperties> {
    private Map<String, Object> files;
    private WorkflowState flowState;
    private WorkflowHealth health;

    public Map<String, Object> files() {
        return this.files;
    }

    public WorkflowEnvelopeProperties withFiles(Map<String, Object> files) {
        this.files = files;
        return this;
    }

    public WorkflowState flowState() {
        return this.flowState;
    }

    public WorkflowEnvelopeProperties withFlowState(WorkflowState flowState) {
        this.flowState = flowState;
        return this;
    }

    public WorkflowHealth health() {
        return this.health;
    }

    public WorkflowEnvelopeProperties withHealth(WorkflowHealth health) {
        this.health = health;
        return this;
    }

    public void validate() {
        if (this.health() != null) {
            this.health().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("files", this.files, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("flowState", this.flowState == null ? null : this.flowState.toString());
        jsonWriter.writeJsonField("health", (JsonSerializable)this.health);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowEnvelopeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowEnvelopeProperties)jsonReader.readObject(reader -> {
            WorkflowEnvelopeProperties deserializedWorkflowEnvelopeProperties = new WorkflowEnvelopeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("files".equals(fieldName)) {
                    Map files;
                    deserializedWorkflowEnvelopeProperties.files = files = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("flowState".equals(fieldName)) {
                    deserializedWorkflowEnvelopeProperties.flowState = WorkflowState.fromString(reader.getString());
                    continue;
                }
                if ("health".equals(fieldName)) {
                    deserializedWorkflowEnvelopeProperties.health = WorkflowHealth.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowEnvelopeProperties;
        });
    }
}

