/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.PrivateLinkConnectionApprovalRequest;
import com.azure.resourcemanager.appservice.models.PrivateLinkConnectionState;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class PrivateLinkConnectionApprovalRequestResource
extends ProxyOnlyResource {
    private PrivateLinkConnectionApprovalRequest innerProperties;
    private String id;
    private String name;
    private String type;

    private PrivateLinkConnectionApprovalRequest innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public PrivateLinkConnectionApprovalRequestResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public PrivateLinkConnectionState privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    public PrivateLinkConnectionApprovalRequestResource withPrivateLinkServiceConnectionState(PrivateLinkConnectionState privateLinkServiceConnectionState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkConnectionApprovalRequest();
        }
        this.innerProperties().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PrivateLinkConnectionApprovalRequestResource fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateLinkConnectionApprovalRequestResource)((Object)jsonReader.readObject(reader -> {
            PrivateLinkConnectionApprovalRequestResource deserializedPrivateLinkConnectionApprovalRequestResource = new PrivateLinkConnectionApprovalRequestResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPrivateLinkConnectionApprovalRequestResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPrivateLinkConnectionApprovalRequestResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPrivateLinkConnectionApprovalRequestResource.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedPrivateLinkConnectionApprovalRequestResource.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPrivateLinkConnectionApprovalRequestResource.innerProperties = PrivateLinkConnectionApprovalRequest.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateLinkConnectionApprovalRequestResource;
        }));
    }
}

