/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigInner;
import com.azure.resourcemanager.appservice.fluent.models.SitePropertiesInner;
import com.azure.resourcemanager.appservice.models.ClientCertMode;
import com.azure.resourcemanager.appservice.models.CloningInfo;
import com.azure.resourcemanager.appservice.models.DaprConfig;
import com.azure.resourcemanager.appservice.models.ExtendedLocation;
import com.azure.resourcemanager.appservice.models.FunctionAppConfig;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.HostnameSslState;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.RedundancyMode;
import com.azure.resourcemanager.appservice.models.ResourceConfig;
import com.azure.resourcemanager.appservice.models.SiteAvailabilityState;
import com.azure.resourcemanager.appservice.models.SiteDnsConfig;
import com.azure.resourcemanager.appservice.models.SlotSwapStatus;
import com.azure.resourcemanager.appservice.models.UsageState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class SiteInner
extends Resource {
    private SitePropertiesInner innerProperties;
    private ManagedServiceIdentity identity;
    private ExtendedLocation extendedLocation;
    private String kind;
    private String id;
    private String name;
    private String type;

    private SitePropertiesInner innerProperties() {
        return this.innerProperties;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public SiteInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public SiteInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public SiteInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public SiteInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SiteInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public List<String> hostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().hostNames();
    }

    public String repositorySiteName() {
        return this.innerProperties() == null ? null : this.innerProperties().repositorySiteName();
    }

    public UsageState usageState() {
        return this.innerProperties() == null ? null : this.innerProperties().usageState();
    }

    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public SiteInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public List<String> enabledHostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledHostNames();
    }

    public SiteAvailabilityState availabilityState() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilityState();
    }

    public List<HostnameSslState> hostnameSslStates() {
        return this.innerProperties() == null ? null : this.innerProperties().hostnameSslStates();
    }

    public SiteInner withHostnameSslStates(List<HostnameSslState> hostnameSslStates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withHostnameSslStates(hostnameSslStates);
        return this;
    }

    public String serverFarmId() {
        return this.innerProperties() == null ? null : this.innerProperties().serverFarmId();
    }

    public SiteInner withServerFarmId(String serverFarmId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withServerFarmId(serverFarmId);
        return this;
    }

    public Boolean reserved() {
        return this.innerProperties() == null ? null : this.innerProperties().reserved();
    }

    public SiteInner withReserved(Boolean reserved) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withReserved(reserved);
        return this;
    }

    public Boolean isXenon() {
        return this.innerProperties() == null ? null : this.innerProperties().isXenon();
    }

    public SiteInner withIsXenon(Boolean isXenon) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withIsXenon(isXenon);
        return this;
    }

    public Boolean hyperV() {
        return this.innerProperties() == null ? null : this.innerProperties().hyperV();
    }

    public SiteInner withHyperV(Boolean hyperV) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withHyperV(hyperV);
        return this;
    }

    public OffsetDateTime lastModifiedTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTimeUtc();
    }

    public SiteDnsConfig dnsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsConfiguration();
    }

    public SiteInner withDnsConfiguration(SiteDnsConfig dnsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withDnsConfiguration(dnsConfiguration);
        return this;
    }

    public Boolean vnetRouteAllEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetRouteAllEnabled();
    }

    public SiteInner withVnetRouteAllEnabled(Boolean vnetRouteAllEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withVnetRouteAllEnabled(vnetRouteAllEnabled);
        return this;
    }

    public Boolean vnetImagePullEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetImagePullEnabled();
    }

    public SiteInner withVnetImagePullEnabled(Boolean vnetImagePullEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withVnetImagePullEnabled(vnetImagePullEnabled);
        return this;
    }

    public Boolean vnetContentShareEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetContentShareEnabled();
    }

    public SiteInner withVnetContentShareEnabled(Boolean vnetContentShareEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withVnetContentShareEnabled(vnetContentShareEnabled);
        return this;
    }

    public Boolean vnetBackupRestoreEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetBackupRestoreEnabled();
    }

    public SiteInner withVnetBackupRestoreEnabled(Boolean vnetBackupRestoreEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withVnetBackupRestoreEnabled(vnetBackupRestoreEnabled);
        return this;
    }

    public SiteConfigInner siteConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().siteConfig();
    }

    public SiteInner withSiteConfig(SiteConfigInner siteConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withSiteConfig(siteConfig);
        return this;
    }

    public FunctionAppConfig functionAppConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().functionAppConfig();
    }

    public SiteInner withFunctionAppConfig(FunctionAppConfig functionAppConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withFunctionAppConfig(functionAppConfig);
        return this;
    }

    public DaprConfig daprConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().daprConfig();
    }

    public SiteInner withDaprConfig(DaprConfig daprConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withDaprConfig(daprConfig);
        return this;
    }

    public String workloadProfileName() {
        return this.innerProperties() == null ? null : this.innerProperties().workloadProfileName();
    }

    public SiteInner withWorkloadProfileName(String workloadProfileName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withWorkloadProfileName(workloadProfileName);
        return this;
    }

    public ResourceConfig resourceConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceConfig();
    }

    public SiteInner withResourceConfig(ResourceConfig resourceConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withResourceConfig(resourceConfig);
        return this;
    }

    public List<String> trafficManagerHostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().trafficManagerHostNames();
    }

    public Boolean scmSiteAlsoStopped() {
        return this.innerProperties() == null ? null : this.innerProperties().scmSiteAlsoStopped();
    }

    public SiteInner withScmSiteAlsoStopped(Boolean scmSiteAlsoStopped) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withScmSiteAlsoStopped(scmSiteAlsoStopped);
        return this;
    }

    public String targetSwapSlot() {
        return this.innerProperties() == null ? null : this.innerProperties().targetSwapSlot();
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().hostingEnvironmentProfile();
    }

    public SiteInner withHostingEnvironmentProfile(HostingEnvironmentProfile hostingEnvironmentProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withHostingEnvironmentProfile(hostingEnvironmentProfile);
        return this;
    }

    public Boolean clientAffinityEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().clientAffinityEnabled();
    }

    public SiteInner withClientAffinityEnabled(Boolean clientAffinityEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withClientAffinityEnabled(clientAffinityEnabled);
        return this;
    }

    public Boolean clientCertEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().clientCertEnabled();
    }

    public SiteInner withClientCertEnabled(Boolean clientCertEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withClientCertEnabled(clientCertEnabled);
        return this;
    }

    public ClientCertMode clientCertMode() {
        return this.innerProperties() == null ? null : this.innerProperties().clientCertMode();
    }

    public SiteInner withClientCertMode(ClientCertMode clientCertMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withClientCertMode(clientCertMode);
        return this;
    }

    public String clientCertExclusionPaths() {
        return this.innerProperties() == null ? null : this.innerProperties().clientCertExclusionPaths();
    }

    public SiteInner withClientCertExclusionPaths(String clientCertExclusionPaths) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withClientCertExclusionPaths(clientCertExclusionPaths);
        return this;
    }

    public Boolean hostNamesDisabled() {
        return this.innerProperties() == null ? null : this.innerProperties().hostNamesDisabled();
    }

    public SiteInner withHostNamesDisabled(Boolean hostNamesDisabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withHostNamesDisabled(hostNamesDisabled);
        return this;
    }

    public String customDomainVerificationId() {
        return this.innerProperties() == null ? null : this.innerProperties().customDomainVerificationId();
    }

    public SiteInner withCustomDomainVerificationId(String customDomainVerificationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withCustomDomainVerificationId(customDomainVerificationId);
        return this;
    }

    public String outboundIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundIpAddresses();
    }

    public String possibleOutboundIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().possibleOutboundIpAddresses();
    }

    public Integer containerSize() {
        return this.innerProperties() == null ? null : this.innerProperties().containerSize();
    }

    public SiteInner withContainerSize(Integer containerSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withContainerSize(containerSize);
        return this;
    }

    public Integer dailyMemoryTimeQuota() {
        return this.innerProperties() == null ? null : this.innerProperties().dailyMemoryTimeQuota();
    }

    public SiteInner withDailyMemoryTimeQuota(Integer dailyMemoryTimeQuota) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withDailyMemoryTimeQuota(dailyMemoryTimeQuota);
        return this;
    }

    public OffsetDateTime suspendedTill() {
        return this.innerProperties() == null ? null : this.innerProperties().suspendedTill();
    }

    public Integer maxNumberOfWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().maxNumberOfWorkers();
    }

    public CloningInfo cloningInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().cloningInfo();
    }

    public SiteInner withCloningInfo(CloningInfo cloningInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withCloningInfo(cloningInfo);
        return this;
    }

    public String resourceGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGroup();
    }

    public Boolean isDefaultContainer() {
        return this.innerProperties() == null ? null : this.innerProperties().isDefaultContainer();
    }

    public String defaultHostname() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultHostname();
    }

    public SlotSwapStatus slotSwapStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().slotSwapStatus();
    }

    public Boolean httpsOnly() {
        return this.innerProperties() == null ? null : this.innerProperties().httpsOnly();
    }

    public SiteInner withHttpsOnly(Boolean httpsOnly) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withHttpsOnly(httpsOnly);
        return this;
    }

    public RedundancyMode redundancyMode() {
        return this.innerProperties() == null ? null : this.innerProperties().redundancyMode();
    }

    public SiteInner withRedundancyMode(RedundancyMode redundancyMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withRedundancyMode(redundancyMode);
        return this;
    }

    public UUID inProgressOperationId() {
        return this.innerProperties() == null ? null : this.innerProperties().inProgressOperationId();
    }

    public String publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public SiteInner withPublicNetworkAccess(String publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public Boolean storageAccountRequired() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountRequired();
    }

    public SiteInner withStorageAccountRequired(Boolean storageAccountRequired) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withStorageAccountRequired(storageAccountRequired);
        return this;
    }

    public String keyVaultReferenceIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultReferenceIdentity();
    }

    public SiteInner withKeyVaultReferenceIdentity(String keyVaultReferenceIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withKeyVaultReferenceIdentity(keyVaultReferenceIdentity);
        return this;
    }

    public String virtualNetworkSubnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkSubnetId();
    }

    public SiteInner withVirtualNetworkSubnetId(String virtualNetworkSubnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withVirtualNetworkSubnetId(virtualNetworkSubnetId);
        return this;
    }

    public String managedEnvironmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedEnvironmentId();
    }

    public SiteInner withManagedEnvironmentId(String managedEnvironmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SitePropertiesInner();
        }
        this.innerProperties().withManagedEnvironmentId(managedEnvironmentId);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    public static SiteInner fromJson(JsonReader jsonReader) throws IOException {
        return (SiteInner)((Object)jsonReader.readObject(reader -> {
            SiteInner deserializedSiteInner = new SiteInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSiteInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSiteInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSiteInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSiteInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSiteInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSiteInner.innerProperties = SitePropertiesInner.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedSiteInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedSiteInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedSiteInner.kind = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSiteInner;
        }));
    }
}

