/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.DetectorDefinition;
import com.azure.resourcemanager.appservice.models.AbnormalTimePeriod;
import com.azure.resourcemanager.appservice.models.AnalysisData;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class DiagnosticAnalysisProperties
implements JsonSerializable<DiagnosticAnalysisProperties> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private List<AbnormalTimePeriod> abnormalTimePeriods;
    private List<AnalysisData> payload;
    private List<DetectorDefinition> nonCorrelatedDetectors;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public DiagnosticAnalysisProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public DiagnosticAnalysisProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<AbnormalTimePeriod> abnormalTimePeriods() {
        return this.abnormalTimePeriods;
    }

    public DiagnosticAnalysisProperties withAbnormalTimePeriods(List<AbnormalTimePeriod> abnormalTimePeriods) {
        this.abnormalTimePeriods = abnormalTimePeriods;
        return this;
    }

    public List<AnalysisData> payload() {
        return this.payload;
    }

    public DiagnosticAnalysisProperties withPayload(List<AnalysisData> payload) {
        this.payload = payload;
        return this;
    }

    public List<DetectorDefinition> nonCorrelatedDetectors() {
        return this.nonCorrelatedDetectors;
    }

    public DiagnosticAnalysisProperties withNonCorrelatedDetectors(List<DetectorDefinition> nonCorrelatedDetectors) {
        this.nonCorrelatedDetectors = nonCorrelatedDetectors;
        return this;
    }

    public void validate() {
        if (this.abnormalTimePeriods() != null) {
            this.abnormalTimePeriods().forEach(e -> e.validate());
        }
        if (this.payload() != null) {
            this.payload().forEach(e -> e.validate());
        }
        if (this.nonCorrelatedDetectors() != null) {
            this.nonCorrelatedDetectors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeArrayField("abnormalTimePeriods", this.abnormalTimePeriods, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("payload", this.payload, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("nonCorrelatedDetectors", this.nonCorrelatedDetectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticAnalysisProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticAnalysisProperties)jsonReader.readObject(reader -> {
            DiagnosticAnalysisProperties deserializedDiagnosticAnalysisProperties = new DiagnosticAnalysisProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedDiagnosticAnalysisProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedDiagnosticAnalysisProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("abnormalTimePeriods".equals(fieldName)) {
                    List abnormalTimePeriods;
                    deserializedDiagnosticAnalysisProperties.abnormalTimePeriods = abnormalTimePeriods = reader.readArray(reader1 -> AbnormalTimePeriod.fromJson(reader1));
                    continue;
                }
                if ("payload".equals(fieldName)) {
                    List payload;
                    deserializedDiagnosticAnalysisProperties.payload = payload = reader.readArray(reader1 -> AnalysisData.fromJson(reader1));
                    continue;
                }
                if ("nonCorrelatedDetectors".equals(fieldName)) {
                    List nonCorrelatedDetectors;
                    deserializedDiagnosticAnalysisProperties.nonCorrelatedDetectors = nonCorrelatedDetectors = reader.readArray(reader1 -> DetectorDefinition.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticAnalysisProperties;
        });
    }
}

