// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

/**
 * App Service plan status.
 */
public enum StatusOptions {
    /**
     * Enum value Ready.
     */
    READY("Ready"),

    /**
     * Enum value Pending.
     */
    PENDING("Pending"),

    /**
     * Enum value Creating.
     */
    CREATING("Creating");

    /**
     * The actual serialized value for a StatusOptions instance.
     */
    private final String value;

    StatusOptions(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a StatusOptions instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed StatusOptions object, or null if unable to parse.
     */
    public static StatusOptions fromString(String value) {
        if (value == null) {
            return null;
        }
        StatusOptions[] items = StatusOptions.values();
        for (StatusOptions item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
