// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Trigger based on range of status codes.
 */
@Fluent
public final class StatusCodesRangeBasedTrigger implements JsonSerializable<StatusCodesRangeBasedTrigger> {
    /*
     * HTTP status code.
     */
    private String statusCodes;

    /*
     * The path property.
     */
    private String path;

    /*
     * Request Count.
     */
    private Integer count;

    /*
     * Time interval.
     */
    private String timeInterval;

    /**
     * Creates an instance of StatusCodesRangeBasedTrigger class.
     */
    public StatusCodesRangeBasedTrigger() {
    }

    /**
     * Get the statusCodes property: HTTP status code.
     * 
     * @return the statusCodes value.
     */
    public String statusCodes() {
        return this.statusCodes;
    }

    /**
     * Set the statusCodes property: HTTP status code.
     * 
     * @param statusCodes the statusCodes value to set.
     * @return the StatusCodesRangeBasedTrigger object itself.
     */
    public StatusCodesRangeBasedTrigger withStatusCodes(String statusCodes) {
        this.statusCodes = statusCodes;
        return this;
    }

    /**
     * Get the path property: The path property.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: The path property.
     * 
     * @param path the path value to set.
     * @return the StatusCodesRangeBasedTrigger object itself.
     */
    public StatusCodesRangeBasedTrigger withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the count property: Request Count.
     * 
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count property: Request Count.
     * 
     * @param count the count value to set.
     * @return the StatusCodesRangeBasedTrigger object itself.
     */
    public StatusCodesRangeBasedTrigger withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Get the timeInterval property: Time interval.
     * 
     * @return the timeInterval value.
     */
    public String timeInterval() {
        return this.timeInterval;
    }

    /**
     * Set the timeInterval property: Time interval.
     * 
     * @param timeInterval the timeInterval value to set.
     * @return the StatusCodesRangeBasedTrigger object itself.
     */
    public StatusCodesRangeBasedTrigger withTimeInterval(String timeInterval) {
        this.timeInterval = timeInterval;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("statusCodes", this.statusCodes);
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeNumberField("count", this.count);
        jsonWriter.writeStringField("timeInterval", this.timeInterval);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StatusCodesRangeBasedTrigger from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StatusCodesRangeBasedTrigger if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StatusCodesRangeBasedTrigger.
     */
    public static StatusCodesRangeBasedTrigger fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StatusCodesRangeBasedTrigger deserializedStatusCodesRangeBasedTrigger = new StatusCodesRangeBasedTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("statusCodes".equals(fieldName)) {
                    deserializedStatusCodesRangeBasedTrigger.statusCodes = reader.getString();
                } else if ("path".equals(fieldName)) {
                    deserializedStatusCodesRangeBasedTrigger.path = reader.getString();
                } else if ("count".equals(fieldName)) {
                    deserializedStatusCodesRangeBasedTrigger.count = reader.getNullable(JsonReader::getInt);
                } else if ("timeInterval".equals(fieldName)) {
                    deserializedStatusCodesRangeBasedTrigger.timeInterval = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStatusCodesRangeBasedTrigger;
        });
    }
}
