// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The status of the last successful slot swap operation.
 */
@Immutable
public final class SlotSwapStatus implements JsonSerializable<SlotSwapStatus> {
    /*
     * The time the last successful slot swap completed.
     */
    private OffsetDateTime timestampUtc;

    /*
     * The source slot of the last swap operation.
     */
    private String sourceSlotName;

    /*
     * The destination slot of the last swap operation.
     */
    private String destinationSlotName;

    /**
     * Creates an instance of SlotSwapStatus class.
     */
    public SlotSwapStatus() {
    }

    /**
     * Get the timestampUtc property: The time the last successful slot swap completed.
     * 
     * @return the timestampUtc value.
     */
    public OffsetDateTime timestampUtc() {
        return this.timestampUtc;
    }

    /**
     * Get the sourceSlotName property: The source slot of the last swap operation.
     * 
     * @return the sourceSlotName value.
     */
    public String sourceSlotName() {
        return this.sourceSlotName;
    }

    /**
     * Get the destinationSlotName property: The destination slot of the last swap operation.
     * 
     * @return the destinationSlotName value.
     */
    public String destinationSlotName() {
        return this.destinationSlotName;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SlotSwapStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SlotSwapStatus if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SlotSwapStatus.
     */
    public static SlotSwapStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SlotSwapStatus deserializedSlotSwapStatus = new SlotSwapStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timestampUtc".equals(fieldName)) {
                    deserializedSlotSwapStatus.timestampUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("sourceSlotName".equals(fieldName)) {
                    deserializedSlotSwapStatus.sourceSlotName = reader.getString();
                } else if ("destinationSlotName".equals(fieldName)) {
                    deserializedSlotSwapStatus.destinationSlotName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSlotSwapStatus;
        });
    }
}
