// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Container App Secret.
 */
@Fluent
public final class Secret implements JsonSerializable<Secret> {
    /*
     * Secret Name.
     */
    private String name;

    /*
     * Secret Value.
     */
    private String value;

    /**
     * Creates an instance of Secret class.
     */
    public Secret() {
    }

    /**
     * Get the name property: Secret Name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Secret Name.
     * 
     * @param name the name value to set.
     * @return the Secret object itself.
     */
    public Secret withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: Secret Value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Secret Value.
     * 
     * @param value the value value to set.
     * @return the Secret object itself.
     */
    public Secret withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Secret from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Secret if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Secret.
     */
    public static Secret fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Secret deserializedSecret = new Secret();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedSecret.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedSecret.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecret;
        });
    }
}
