// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A private link resource.
 */
@Fluent
public final class PrivateLinkResource implements JsonSerializable<PrivateLinkResource> {
    /*
     * The id property.
     */
    private String id;

    /*
     * Name of a private link resource
     */
    private String name;

    /*
     * The type property.
     */
    private String type;

    /*
     * Properties of a private link resource
     */
    private PrivateLinkResourceProperties properties;

    /**
     * Creates an instance of PrivateLinkResource class.
     */
    public PrivateLinkResource() {
    }

    /**
     * Get the id property: The id property.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The id property.
     * 
     * @param id the id value to set.
     * @return the PrivateLinkResource object itself.
     */
    public PrivateLinkResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: Name of a private link resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of a private link resource.
     * 
     * @param name the name value to set.
     * @return the PrivateLinkResource object itself.
     */
    public PrivateLinkResource withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The type property.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type property.
     * 
     * @param type the type value to set.
     * @return the PrivateLinkResource object itself.
     */
    public PrivateLinkResource withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the properties property: Properties of a private link resource.
     * 
     * @return the properties value.
     */
    public PrivateLinkResourceProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of a private link resource.
     * 
     * @param properties the properties value to set.
     * @return the PrivateLinkResource object itself.
     */
    public PrivateLinkResource withProperties(PrivateLinkResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model PrivateLinkResource"));
        }
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model PrivateLinkResource"));
        }
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model PrivateLinkResource"));
        }
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property properties in model PrivateLinkResource"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateLinkResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateLinkResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PrivateLinkResource.
     */
    public static PrivateLinkResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateLinkResource deserializedPrivateLinkResource = new PrivateLinkResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPrivateLinkResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPrivateLinkResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPrivateLinkResource.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedPrivateLinkResource.properties = PrivateLinkResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateLinkResource;
        });
    }
}
