// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * GitHub Actions Web App stack settings.
 */
@Immutable
public final class GitHubActionWebAppStackSettings implements JsonSerializable<GitHubActionWebAppStackSettings> {
    /*
     * <code>true</code> if GitHub Actions is supported for the stack; otherwise, <code>false</code>.
     */
    private Boolean isSupported;

    /*
     * The minor version that is supported for GitHub Actions.
     */
    private String supportedVersion;

    /**
     * Creates an instance of GitHubActionWebAppStackSettings class.
     */
    public GitHubActionWebAppStackSettings() {
    }

    /**
     * Get the isSupported property: &lt;code&gt;true&lt;/code&gt; if GitHub Actions is supported for the stack;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isSupported value.
     */
    public Boolean isSupported() {
        return this.isSupported;
    }

    /**
     * Get the supportedVersion property: The minor version that is supported for GitHub Actions.
     * 
     * @return the supportedVersion value.
     */
    public String supportedVersion() {
        return this.supportedVersion;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GitHubActionWebAppStackSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GitHubActionWebAppStackSettings if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GitHubActionWebAppStackSettings.
     */
    public static GitHubActionWebAppStackSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GitHubActionWebAppStackSettings deserializedGitHubActionWebAppStackSettings
                = new GitHubActionWebAppStackSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isSupported".equals(fieldName)) {
                    deserializedGitHubActionWebAppStackSettings.isSupported
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("supportedVersion".equals(fieldName)) {
                    deserializedGitHubActionWebAppStackSettings.supportedVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGitHubActionWebAppStackSettings;
        });
    }
}
