// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Function app configuration.
 */
@Fluent
public final class FunctionAppConfig implements JsonSerializable<FunctionAppConfig> {
    /*
     * Function app deployment configuration.
     */
    private FunctionsDeployment deployment;

    /*
     * Function app runtime settings.
     */
    private FunctionsRuntime runtime;

    /*
     * Function app scale and concurrency settings.
     */
    private FunctionsScaleAndConcurrency scaleAndConcurrency;

    /**
     * Creates an instance of FunctionAppConfig class.
     */
    public FunctionAppConfig() {
    }

    /**
     * Get the deployment property: Function app deployment configuration.
     * 
     * @return the deployment value.
     */
    public FunctionsDeployment deployment() {
        return this.deployment;
    }

    /**
     * Set the deployment property: Function app deployment configuration.
     * 
     * @param deployment the deployment value to set.
     * @return the FunctionAppConfig object itself.
     */
    public FunctionAppConfig withDeployment(FunctionsDeployment deployment) {
        this.deployment = deployment;
        return this;
    }

    /**
     * Get the runtime property: Function app runtime settings.
     * 
     * @return the runtime value.
     */
    public FunctionsRuntime runtime() {
        return this.runtime;
    }

    /**
     * Set the runtime property: Function app runtime settings.
     * 
     * @param runtime the runtime value to set.
     * @return the FunctionAppConfig object itself.
     */
    public FunctionAppConfig withRuntime(FunctionsRuntime runtime) {
        this.runtime = runtime;
        return this;
    }

    /**
     * Get the scaleAndConcurrency property: Function app scale and concurrency settings.
     * 
     * @return the scaleAndConcurrency value.
     */
    public FunctionsScaleAndConcurrency scaleAndConcurrency() {
        return this.scaleAndConcurrency;
    }

    /**
     * Set the scaleAndConcurrency property: Function app scale and concurrency settings.
     * 
     * @param scaleAndConcurrency the scaleAndConcurrency value to set.
     * @return the FunctionAppConfig object itself.
     */
    public FunctionAppConfig withScaleAndConcurrency(FunctionsScaleAndConcurrency scaleAndConcurrency) {
        this.scaleAndConcurrency = scaleAndConcurrency;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (deployment() != null) {
            deployment().validate();
        }
        if (runtime() != null) {
            runtime().validate();
        }
        if (scaleAndConcurrency() != null) {
            scaleAndConcurrency().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("deployment", this.deployment);
        jsonWriter.writeJsonField("runtime", this.runtime);
        jsonWriter.writeJsonField("scaleAndConcurrency", this.scaleAndConcurrency);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FunctionAppConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FunctionAppConfig if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FunctionAppConfig.
     */
    public static FunctionAppConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FunctionAppConfig deserializedFunctionAppConfig = new FunctionAppConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("deployment".equals(fieldName)) {
                    deserializedFunctionAppConfig.deployment = FunctionsDeployment.fromJson(reader);
                } else if ("runtime".equals(fieldName)) {
                    deserializedFunctionAppConfig.runtime = FunctionsRuntime.fromJson(reader);
                } else if ("scaleAndConcurrency".equals(fieldName)) {
                    deserializedFunctionAppConfig.scaleAndConcurrency = FunctionsScaleAndConcurrency.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFunctionAppConfig;
        });
    }
}
