// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The expression traces.
 */
@Fluent
public final class ExpressionTraces implements JsonSerializable<ExpressionTraces> {
    /*
     * Anything
     */
    private Object value;

    /*
     * The inputs property.
     */
    private List<ExpressionRoot> inputs;

    /*
     * The link used to get the next page of recommendations.
     */
    private String nextLink;

    /**
     * Creates an instance of ExpressionTraces class.
     */
    public ExpressionTraces() {
    }

    /**
     * Get the value property: Anything.
     * 
     * @return the value value.
     */
    public Object value() {
        return this.value;
    }

    /**
     * Set the value property: Anything.
     * 
     * @param value the value value to set.
     * @return the ExpressionTraces object itself.
     */
    public ExpressionTraces withValue(Object value) {
        this.value = value;
        return this;
    }

    /**
     * Get the inputs property: The inputs property.
     * 
     * @return the inputs value.
     */
    public List<ExpressionRoot> inputs() {
        return this.inputs;
    }

    /**
     * Set the inputs property: The inputs property.
     * 
     * @param inputs the inputs value to set.
     * @return the ExpressionTraces object itself.
     */
    public ExpressionTraces withInputs(List<ExpressionRoot> inputs) {
        this.inputs = inputs;
        return this;
    }

    /**
     * Get the nextLink property: The link used to get the next page of recommendations.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link used to get the next page of recommendations.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ExpressionTraces object itself.
     */
    public ExpressionTraces withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (inputs() != null) {
            inputs().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("value", this.value);
        jsonWriter.writeArrayField("inputs", this.inputs, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressionTraces from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressionTraces if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressionTraces.
     */
    public static ExpressionTraces fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressionTraces deserializedExpressionTraces = new ExpressionTraces();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedExpressionTraces.value = reader.readUntyped();
                } else if ("inputs".equals(fieldName)) {
                    List<ExpressionRoot> inputs = reader.readArray(reader1 -> ExpressionRoot.fromJson(reader1));
                    deserializedExpressionTraces.inputs = inputs;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedExpressionTraces.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressionTraces;
        });
    }
}
