// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Enabled configuration.
 */
@Fluent
public final class EnabledConfig implements JsonSerializable<EnabledConfig> {
    /*
     * True if configuration is enabled, false if it is disabled and null if configuration is not set.
     */
    private Boolean enabled;

    /**
     * Creates an instance of EnabledConfig class.
     */
    public EnabledConfig() {
    }

    /**
     * Get the enabled property: True if configuration is enabled, false if it is disabled and null if configuration is
     * not set.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: True if configuration is enabled, false if it is disabled and null if configuration is
     * not set.
     * 
     * @param enabled the enabled value to set.
     * @return the EnabledConfig object itself.
     */
    public EnabledConfig withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EnabledConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EnabledConfig if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EnabledConfig.
     */
    public static EnabledConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EnabledConfig deserializedEnabledConfig = new EnabledConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedEnabledConfig.enabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEnabledConfig;
        });
    }
}
