// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Database backup settings.
 */
@Fluent
public final class DatabaseBackupSetting implements JsonSerializable<DatabaseBackupSetting> {
    /*
     * Database type (e.g. SqlAzure / MySql).
     */
    private DatabaseType databaseType;

    /*
     * The name property.
     */
    private String name;

    /*
     * Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
     * This is used during restore with overwrite connection strings options.
     */
    private String connectionStringName;

    /*
     * Contains a connection string to a database which is being backed up or restored. If the restore should happen to
     * a new database, the database name inside is the new one.
     */
    private String connectionString;

    /**
     * Creates an instance of DatabaseBackupSetting class.
     */
    public DatabaseBackupSetting() {
    }

    /**
     * Get the databaseType property: Database type (e.g. SqlAzure / MySql).
     * 
     * @return the databaseType value.
     */
    public DatabaseType databaseType() {
        return this.databaseType;
    }

    /**
     * Set the databaseType property: Database type (e.g. SqlAzure / MySql).
     * 
     * @param databaseType the databaseType value to set.
     * @return the DatabaseBackupSetting object itself.
     */
    public DatabaseBackupSetting withDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    /**
     * Get the name property: The name property.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name property.
     * 
     * @param name the name value to set.
     * @return the DatabaseBackupSetting object itself.
     */
    public DatabaseBackupSetting withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the connectionStringName property: Contains a connection string name that is linked to the
     * SiteConfig.ConnectionStrings.
     * This is used during restore with overwrite connection strings options.
     * 
     * @return the connectionStringName value.
     */
    public String connectionStringName() {
        return this.connectionStringName;
    }

    /**
     * Set the connectionStringName property: Contains a connection string name that is linked to the
     * SiteConfig.ConnectionStrings.
     * This is used during restore with overwrite connection strings options.
     * 
     * @param connectionStringName the connectionStringName value to set.
     * @return the DatabaseBackupSetting object itself.
     */
    public DatabaseBackupSetting withConnectionStringName(String connectionStringName) {
        this.connectionStringName = connectionStringName;
        return this;
    }

    /**
     * Get the connectionString property: Contains a connection string to a database which is being backed up or
     * restored. If the restore should happen to a new database, the database name inside is the new one.
     * 
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: Contains a connection string to a database which is being backed up or
     * restored. If the restore should happen to a new database, the database name inside is the new one.
     * 
     * @param connectionString the connectionString value to set.
     * @return the DatabaseBackupSetting object itself.
     */
    public DatabaseBackupSetting withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (databaseType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property databaseType in model DatabaseBackupSetting"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DatabaseBackupSetting.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseType", this.databaseType == null ? null : this.databaseType.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("connectionStringName", this.connectionStringName);
        jsonWriter.writeStringField("connectionString", this.connectionString);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseBackupSetting from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseBackupSetting if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DatabaseBackupSetting.
     */
    public static DatabaseBackupSetting fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseBackupSetting deserializedDatabaseBackupSetting = new DatabaseBackupSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("databaseType".equals(fieldName)) {
                    deserializedDatabaseBackupSetting.databaseType = DatabaseType.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedDatabaseBackupSetting.name = reader.getString();
                } else if ("connectionStringName".equals(fieldName)) {
                    deserializedDatabaseBackupSetting.connectionStringName = reader.getString();
                } else if ("connectionString".equals(fieldName)) {
                    deserializedDatabaseBackupSetting.connectionString = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseBackupSetting;
        });
    }
}
