// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The content link.
 */
@Fluent
public final class ContentLink implements JsonSerializable<ContentLink> {
    /*
     * The content link URI.
     */
    private String uri;

    /*
     * The content version.
     */
    private String contentVersion;

    /*
     * The content size.
     */
    private Long contentSize;

    /*
     * The content hash.
     */
    private ContentHash contentHash;

    /*
     * The metadata.
     */
    private Object metadata;

    /**
     * Creates an instance of ContentLink class.
     */
    public ContentLink() {
    }

    /**
     * Get the uri property: The content link URI.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: The content link URI.
     * 
     * @param uri the uri value to set.
     * @return the ContentLink object itself.
     */
    public ContentLink withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the contentVersion property: The content version.
     * 
     * @return the contentVersion value.
     */
    public String contentVersion() {
        return this.contentVersion;
    }

    /**
     * Get the contentSize property: The content size.
     * 
     * @return the contentSize value.
     */
    public Long contentSize() {
        return this.contentSize;
    }

    /**
     * Get the contentHash property: The content hash.
     * 
     * @return the contentHash value.
     */
    public ContentHash contentHash() {
        return this.contentHash;
    }

    /**
     * Get the metadata property: The metadata.
     * 
     * @return the metadata value.
     */
    public Object metadata() {
        return this.metadata;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (contentHash() != null) {
            contentHash().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.uri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContentLink from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContentLink if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContentLink.
     */
    public static ContentLink fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContentLink deserializedContentLink = new ContentLink();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("uri".equals(fieldName)) {
                    deserializedContentLink.uri = reader.getString();
                } else if ("contentVersion".equals(fieldName)) {
                    deserializedContentLink.contentVersion = reader.getString();
                } else if ("contentSize".equals(fieldName)) {
                    deserializedContentLink.contentSize = reader.getNullable(JsonReader::getLong);
                } else if ("contentHash".equals(fieldName)) {
                    deserializedContentLink.contentHash = ContentHash.fromJson(reader);
                } else if ("metadata".equals(fieldName)) {
                    deserializedContentLink.metadata = reader.readUntyped();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContentLink;
        });
    }
}
