// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.TriggeredJobRun;
import java.io.IOException;
import java.util.List;

/**
 * Triggered Web Job History. List of Triggered Web Job Run Information elements.
 */
@Fluent
public final class TriggeredJobHistoryInner extends ProxyOnlyResource {
    /*
     * TriggeredJobHistory resource specific properties
     */
    private TriggeredJobHistoryProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of TriggeredJobHistoryInner class.
     */
    public TriggeredJobHistoryInner() {
    }

    /**
     * Get the innerProperties property: TriggeredJobHistory resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private TriggeredJobHistoryProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TriggeredJobHistoryInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the runs property: List of triggered web job runs.
     * 
     * @return the runs value.
     */
    public List<TriggeredJobRun> runs() {
        return this.innerProperties() == null ? null : this.innerProperties().runs();
    }

    /**
     * Set the runs property: List of triggered web job runs.
     * 
     * @param runs the runs value to set.
     * @return the TriggeredJobHistoryInner object itself.
     */
    public TriggeredJobHistoryInner withRuns(List<TriggeredJobRun> runs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TriggeredJobHistoryProperties();
        }
        this.innerProperties().withRuns(runs);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TriggeredJobHistoryInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TriggeredJobHistoryInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TriggeredJobHistoryInner.
     */
    public static TriggeredJobHistoryInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TriggeredJobHistoryInner deserializedTriggeredJobHistoryInner = new TriggeredJobHistoryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTriggeredJobHistoryInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedTriggeredJobHistoryInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedTriggeredJobHistoryInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedTriggeredJobHistoryInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedTriggeredJobHistoryInner.innerProperties
                        = TriggeredJobHistoryProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTriggeredJobHistoryInner;
        });
    }
}
