// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Static Site User Provided Function App ARM resource.
 */
@Fluent
public final class StaticSiteUserProvidedFunctionAppArmResourceInner extends ProxyOnlyResource {
    /*
     * StaticSiteUserProvidedFunctionAppARMResource resource specific properties
     */
    private StaticSiteUserProvidedFunctionAppArmResourceProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of StaticSiteUserProvidedFunctionAppArmResourceInner class.
     */
    public StaticSiteUserProvidedFunctionAppArmResourceInner() {
    }

    /**
     * Get the innerProperties property: StaticSiteUserProvidedFunctionAppARMResource resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private StaticSiteUserProvidedFunctionAppArmResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StaticSiteUserProvidedFunctionAppArmResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the functionAppResourceId property: The resource id of the function app registered with the static site.
     * 
     * @return the functionAppResourceId value.
     */
    public String functionAppResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().functionAppResourceId();
    }

    /**
     * Set the functionAppResourceId property: The resource id of the function app registered with the static site.
     * 
     * @param functionAppResourceId the functionAppResourceId value to set.
     * @return the StaticSiteUserProvidedFunctionAppArmResourceInner object itself.
     */
    public StaticSiteUserProvidedFunctionAppArmResourceInner withFunctionAppResourceId(String functionAppResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserProvidedFunctionAppArmResourceProperties();
        }
        this.innerProperties().withFunctionAppResourceId(functionAppResourceId);
        return this;
    }

    /**
     * Get the functionAppRegion property: The region of the function app registered with the static site.
     * 
     * @return the functionAppRegion value.
     */
    public String functionAppRegion() {
        return this.innerProperties() == null ? null : this.innerProperties().functionAppRegion();
    }

    /**
     * Set the functionAppRegion property: The region of the function app registered with the static site.
     * 
     * @param functionAppRegion the functionAppRegion value to set.
     * @return the StaticSiteUserProvidedFunctionAppArmResourceInner object itself.
     */
    public StaticSiteUserProvidedFunctionAppArmResourceInner withFunctionAppRegion(String functionAppRegion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserProvidedFunctionAppArmResourceProperties();
        }
        this.innerProperties().withFunctionAppRegion(functionAppRegion);
        return this;
    }

    /**
     * Get the createdOn property: The date and time on which the function app was registered with the static site.
     * 
     * @return the createdOn value.
     */
    public OffsetDateTime createdOn() {
        return this.innerProperties() == null ? null : this.innerProperties().createdOn();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticSiteUserProvidedFunctionAppArmResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticSiteUserProvidedFunctionAppArmResourceInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StaticSiteUserProvidedFunctionAppArmResourceInner.
     */
    public static StaticSiteUserProvidedFunctionAppArmResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticSiteUserProvidedFunctionAppArmResourceInner deserializedStaticSiteUserProvidedFunctionAppArmResourceInner
                = new StaticSiteUserProvidedFunctionAppArmResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedStaticSiteUserProvidedFunctionAppArmResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStaticSiteUserProvidedFunctionAppArmResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStaticSiteUserProvidedFunctionAppArmResourceInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedStaticSiteUserProvidedFunctionAppArmResourceInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedStaticSiteUserProvidedFunctionAppArmResourceInner.innerProperties
                        = StaticSiteUserProvidedFunctionAppArmResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticSiteUserProvidedFunctionAppArmResourceInner;
        });
    }
}
