// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * A snapshot of an app.
 */
@Fluent
public final class SnapshotInner extends ProxyOnlyResource {
    /*
     * Snapshot resource specific properties
     */
    private SnapshotProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of SnapshotInner class.
     */
    public SnapshotInner() {
    }

    /**
     * Get the innerProperties property: Snapshot resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private SnapshotProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SnapshotInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the time property: The time the snapshot was taken.
     * 
     * @return the time value.
     */
    public String time() {
        return this.innerProperties() == null ? null : this.innerProperties().time();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SnapshotInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SnapshotInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SnapshotInner.
     */
    public static SnapshotInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SnapshotInner deserializedSnapshotInner = new SnapshotInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSnapshotInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSnapshotInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSnapshotInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedSnapshotInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedSnapshotInner.innerProperties = SnapshotProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSnapshotInner;
        });
    }
}
