// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * A setting difference between two deployment slots of an app.
 */
@Fluent
public final class SlotDifferenceInner extends ProxyOnlyResource {
    /*
     * SlotDifference resource specific properties
     */
    private SlotDifferenceProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of SlotDifferenceInner class.
     */
    public SlotDifferenceInner() {
    }

    /**
     * Get the innerProperties property: SlotDifference resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private SlotDifferenceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SlotDifferenceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the level property: Level of the difference: Information, Warning or Error.
     * 
     * @return the level value.
     */
    public String level() {
        return this.innerProperties() == null ? null : this.innerProperties().level();
    }

    /**
     * Get the settingType property: The type of the setting: General, AppSetting or ConnectionString.
     * 
     * @return the settingType value.
     */
    public String settingType() {
        return this.innerProperties() == null ? null : this.innerProperties().settingType();
    }

    /**
     * Get the diffRule property: Rule that describes how to process the setting difference during a slot swap.
     * 
     * @return the diffRule value.
     */
    public String diffRule() {
        return this.innerProperties() == null ? null : this.innerProperties().diffRule();
    }

    /**
     * Get the settingName property: Name of the setting.
     * 
     * @return the settingName value.
     */
    public String settingName() {
        return this.innerProperties() == null ? null : this.innerProperties().settingName();
    }

    /**
     * Get the valueInCurrentSlot property: Value of the setting in the current slot.
     * 
     * @return the valueInCurrentSlot value.
     */
    public String valueInCurrentSlot() {
        return this.innerProperties() == null ? null : this.innerProperties().valueInCurrentSlot();
    }

    /**
     * Get the valueInTargetSlot property: Value of the setting in the target slot.
     * 
     * @return the valueInTargetSlot value.
     */
    public String valueInTargetSlot() {
        return this.innerProperties() == null ? null : this.innerProperties().valueInTargetSlot();
    }

    /**
     * Get the description property: Description of the setting difference.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SlotDifferenceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SlotDifferenceInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SlotDifferenceInner.
     */
    public static SlotDifferenceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SlotDifferenceInner deserializedSlotDifferenceInner = new SlotDifferenceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSlotDifferenceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSlotDifferenceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSlotDifferenceInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedSlotDifferenceInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedSlotDifferenceInner.innerProperties = SlotDifferenceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSlotDifferenceInner;
        });
    }
}
