// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AuthPlatform;
import com.azure.resourcemanager.appservice.models.GlobalValidation;
import com.azure.resourcemanager.appservice.models.HttpSettings;
import com.azure.resourcemanager.appservice.models.IdentityProviders;
import com.azure.resourcemanager.appservice.models.Login;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * Configuration settings for the Azure App Service Authentication / Authorization V2 feature.
 */
@Fluent
public final class SiteAuthSettingsV2Inner extends ProxyOnlyResource {
    /*
     * SiteAuthSettingsV2 resource specific properties
     */
    private SiteAuthSettingsV2Properties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of SiteAuthSettingsV2Inner class.
     */
    public SiteAuthSettingsV2Inner() {
    }

    /**
     * Get the innerProperties property: SiteAuthSettingsV2 resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private SiteAuthSettingsV2Properties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SiteAuthSettingsV2Inner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the platform property: The configuration settings of the platform of App Service
     * Authentication/Authorization.
     * 
     * @return the platform value.
     */
    public AuthPlatform platform() {
        return this.innerProperties() == null ? null : this.innerProperties().platform();
    }

    /**
     * Set the platform property: The configuration settings of the platform of App Service
     * Authentication/Authorization.
     * 
     * @param platform the platform value to set.
     * @return the SiteAuthSettingsV2Inner object itself.
     */
    public SiteAuthSettingsV2Inner withPlatform(AuthPlatform platform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteAuthSettingsV2Properties();
        }
        this.innerProperties().withPlatform(platform);
        return this;
    }

    /**
     * Get the globalValidation property: The configuration settings that determines the validation flow of users using
     * App Service Authentication/Authorization.
     * 
     * @return the globalValidation value.
     */
    public GlobalValidation globalValidation() {
        return this.innerProperties() == null ? null : this.innerProperties().globalValidation();
    }

    /**
     * Set the globalValidation property: The configuration settings that determines the validation flow of users using
     * App Service Authentication/Authorization.
     * 
     * @param globalValidation the globalValidation value to set.
     * @return the SiteAuthSettingsV2Inner object itself.
     */
    public SiteAuthSettingsV2Inner withGlobalValidation(GlobalValidation globalValidation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteAuthSettingsV2Properties();
        }
        this.innerProperties().withGlobalValidation(globalValidation);
        return this;
    }

    /**
     * Get the identityProviders property: The configuration settings of each of the identity providers used to
     * configure App Service Authentication/Authorization.
     * 
     * @return the identityProviders value.
     */
    public IdentityProviders identityProviders() {
        return this.innerProperties() == null ? null : this.innerProperties().identityProviders();
    }

    /**
     * Set the identityProviders property: The configuration settings of each of the identity providers used to
     * configure App Service Authentication/Authorization.
     * 
     * @param identityProviders the identityProviders value to set.
     * @return the SiteAuthSettingsV2Inner object itself.
     */
    public SiteAuthSettingsV2Inner withIdentityProviders(IdentityProviders identityProviders) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteAuthSettingsV2Properties();
        }
        this.innerProperties().withIdentityProviders(identityProviders);
        return this;
    }

    /**
     * Get the login property: The configuration settings of the login flow of users using App Service
     * Authentication/Authorization.
     * 
     * @return the login value.
     */
    public Login login() {
        return this.innerProperties() == null ? null : this.innerProperties().login();
    }

    /**
     * Set the login property: The configuration settings of the login flow of users using App Service
     * Authentication/Authorization.
     * 
     * @param login the login value to set.
     * @return the SiteAuthSettingsV2Inner object itself.
     */
    public SiteAuthSettingsV2Inner withLogin(Login login) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteAuthSettingsV2Properties();
        }
        this.innerProperties().withLogin(login);
        return this;
    }

    /**
     * Get the httpSettings property: The configuration settings of the HTTP requests for authentication and
     * authorization requests made against App Service Authentication/Authorization.
     * 
     * @return the httpSettings value.
     */
    public HttpSettings httpSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().httpSettings();
    }

    /**
     * Set the httpSettings property: The configuration settings of the HTTP requests for authentication and
     * authorization requests made against App Service Authentication/Authorization.
     * 
     * @param httpSettings the httpSettings value to set.
     * @return the SiteAuthSettingsV2Inner object itself.
     */
    public SiteAuthSettingsV2Inner withHttpSettings(HttpSettings httpSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteAuthSettingsV2Properties();
        }
        this.innerProperties().withHttpSettings(httpSettings);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteAuthSettingsV2Inner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteAuthSettingsV2Inner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SiteAuthSettingsV2Inner.
     */
    public static SiteAuthSettingsV2Inner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteAuthSettingsV2Inner deserializedSiteAuthSettingsV2Inner = new SiteAuthSettingsV2Inner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSiteAuthSettingsV2Inner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSiteAuthSettingsV2Inner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSiteAuthSettingsV2Inner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedSiteAuthSettingsV2Inner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedSiteAuthSettingsV2Inner.innerProperties = SiteAuthSettingsV2Properties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteAuthSettingsV2Inner;
        });
    }
}
