// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.RequestHistoryProperties;
import com.azure.resourcemanager.appservice.models.WorkflowResource;
import java.io.IOException;
import java.util.Map;

/**
 * The request history.
 */
@Fluent
public final class RequestHistoryInner extends WorkflowResource {
    /*
     * The request history properties.
     */
    private RequestHistoryProperties properties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of RequestHistoryInner class.
     */
    public RequestHistoryInner() {
    }

    /**
     * Get the properties property: The request history properties.
     * 
     * @return the properties value.
     */
    public RequestHistoryProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The request history properties.
     * 
     * @param properties the properties value to set.
     * @return the RequestHistoryInner object itself.
     */
    public RequestHistoryInner withProperties(RequestHistoryProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RequestHistoryInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RequestHistoryInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RequestHistoryInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RequestHistoryInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RequestHistoryInner.
     */
    public static RequestHistoryInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RequestHistoryInner deserializedRequestHistoryInner = new RequestHistoryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRequestHistoryInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRequestHistoryInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRequestHistoryInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedRequestHistoryInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRequestHistoryInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedRequestHistoryInner.properties = RequestHistoryProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRequestHistoryInner;
        });
    }
}
