// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.util.List;

/**
 * Full view of network features for an app (presently VNET integration and Hybrid Connections).
 */
@Fluent
public final class NetworkFeaturesInner extends ProxyOnlyResource {
    /*
     * NetworkFeatures resource specific properties
     */
    private NetworkFeaturesProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of NetworkFeaturesInner class.
     */
    public NetworkFeaturesInner() {
    }

    /**
     * Get the innerProperties property: NetworkFeatures resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private NetworkFeaturesProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NetworkFeaturesInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the virtualNetworkName property: The Virtual Network name.
     * 
     * @return the virtualNetworkName value.
     */
    public String virtualNetworkName() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkName();
    }

    /**
     * Get the virtualNetworkConnection property: The Virtual Network summary view.
     * 
     * @return the virtualNetworkConnection value.
     */
    public VnetInfo virtualNetworkConnection() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkConnection();
    }

    /**
     * Get the hybridConnections property: The Hybrid Connections summary view.
     * 
     * @return the hybridConnections value.
     */
    public List<RelayServiceConnectionEntityInner> hybridConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridConnections();
    }

    /**
     * Get the hybridConnectionsV2 property: The Hybrid Connection V2 (Service Bus) view.
     * 
     * @return the hybridConnectionsV2 value.
     */
    public List<HybridConnectionInner> hybridConnectionsV2() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridConnectionsV2();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkFeaturesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkFeaturesInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NetworkFeaturesInner.
     */
    public static NetworkFeaturesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkFeaturesInner deserializedNetworkFeaturesInner = new NetworkFeaturesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNetworkFeaturesInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNetworkFeaturesInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNetworkFeaturesInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedNetworkFeaturesInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedNetworkFeaturesInner.innerProperties = NetworkFeaturesProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkFeaturesInner;
        });
    }
}
