// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.BackupItemStatus;
import com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Backup description.
 */
@Fluent
public final class BackupItemInner extends ProxyOnlyResource {
    /*
     * BackupItem resource specific properties
     */
    private BackupItemProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of BackupItemInner class.
     */
    public BackupItemInner() {
    }

    /**
     * Get the innerProperties property: BackupItem resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private BackupItemProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public BackupItemInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the backupId property: Id of the backup.
     * 
     * @return the backupId value.
     */
    public Integer backupId() {
        return this.innerProperties() == null ? null : this.innerProperties().backupId();
    }

    /**
     * Get the storageAccountUrl property: SAS URL for the storage account container which contains this backup.
     * 
     * @return the storageAccountUrl value.
     */
    public String storageAccountUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountUrl();
    }

    /**
     * Get the blobName property: Name of the blob which contains data for this backup.
     * 
     * @return the blobName value.
     */
    public String blobName() {
        return this.innerProperties() == null ? null : this.innerProperties().blobName();
    }

    /**
     * Get the name property: Name of this backup.
     * 
     * @return the name value.
     */
    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    /**
     * Get the status property: Backup status.
     * 
     * @return the status value.
     */
    public BackupItemStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the sizeInBytes property: Size of the backup in bytes.
     * 
     * @return the sizeInBytes value.
     */
    public Long sizeInBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().sizeInBytes();
    }

    /**
     * Get the created property: Timestamp of the backup creation.
     * 
     * @return the created value.
     */
    public OffsetDateTime created() {
        return this.innerProperties() == null ? null : this.innerProperties().created();
    }

    /**
     * Get the log property: Details regarding this backup. Might contain an error message.
     * 
     * @return the log value.
     */
    public String log() {
        return this.innerProperties() == null ? null : this.innerProperties().log();
    }

    /**
     * Get the databases property: List of databases included in the backup.
     * 
     * @return the databases value.
     */
    public List<DatabaseBackupSetting> databases() {
        return this.innerProperties() == null ? null : this.innerProperties().databases();
    }

    /**
     * Get the scheduled property: True if this backup has been created due to a schedule being triggered.
     * 
     * @return the scheduled value.
     */
    public Boolean scheduled() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduled();
    }

    /**
     * Get the lastRestoreTimestamp property: Timestamp of a last restore operation which used this backup.
     * 
     * @return the lastRestoreTimestamp value.
     */
    public OffsetDateTime lastRestoreTimestamp() {
        return this.innerProperties() == null ? null : this.innerProperties().lastRestoreTimestamp();
    }

    /**
     * Get the finishedTimestamp property: Timestamp when this backup finished.
     * 
     * @return the finishedTimestamp value.
     */
    public OffsetDateTime finishedTimestamp() {
        return this.innerProperties() == null ? null : this.innerProperties().finishedTimestamp();
    }

    /**
     * Get the correlationId property: Unique correlation identifier. Please use this along with the timestamp while
     * communicating with Azure support.
     * 
     * @return the correlationId value.
     */
    public String correlationId() {
        return this.innerProperties() == null ? null : this.innerProperties().correlationId();
    }

    /**
     * Get the websiteSizeInBytes property: Size of the original web app which has been backed up.
     * 
     * @return the websiteSizeInBytes value.
     */
    public Long websiteSizeInBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().websiteSizeInBytes();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackupItemInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackupItemInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BackupItemInner.
     */
    public static BackupItemInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackupItemInner deserializedBackupItemInner = new BackupItemInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBackupItemInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedBackupItemInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedBackupItemInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedBackupItemInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedBackupItemInner.innerProperties = BackupItemProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackupItemInner;
        });
    }
}
