// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ConfigReferenceSource;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.ResolveStatus;
import java.io.IOException;

/**
 * Description of site key vault references.
 */
@Fluent
public final class ApiKVReferenceInner extends ProxyOnlyResource {
    /*
     * ApiKVReference resource specific properties
     */
    private ApiKVReferenceProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ApiKVReferenceInner class.
     */
    public ApiKVReferenceInner() {
    }

    /**
     * Get the innerProperties property: ApiKVReference resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private ApiKVReferenceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiKVReferenceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the reference property: The reference property.
     * 
     * @return the reference value.
     */
    public String reference() {
        return this.innerProperties() == null ? null : this.innerProperties().reference();
    }

    /**
     * Set the reference property: The reference property.
     * 
     * @param reference the reference value to set.
     * @return the ApiKVReferenceInner object itself.
     */
    public ApiKVReferenceInner withReference(String reference) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withReference(reference);
        return this;
    }

    /**
     * Get the status property: The status property.
     * 
     * @return the status value.
     */
    public ResolveStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: The status property.
     * 
     * @param status the status value to set.
     * @return the ApiKVReferenceInner object itself.
     */
    public ApiKVReferenceInner withStatus(ResolveStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the vaultName property: The vaultName property.
     * 
     * @return the vaultName value.
     */
    public String vaultName() {
        return this.innerProperties() == null ? null : this.innerProperties().vaultName();
    }

    /**
     * Set the vaultName property: The vaultName property.
     * 
     * @param vaultName the vaultName value to set.
     * @return the ApiKVReferenceInner object itself.
     */
    public ApiKVReferenceInner withVaultName(String vaultName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withVaultName(vaultName);
        return this;
    }

    /**
     * Get the secretName property: The secretName property.
     * 
     * @return the secretName value.
     */
    public String secretName() {
        return this.innerProperties() == null ? null : this.innerProperties().secretName();
    }

    /**
     * Set the secretName property: The secretName property.
     * 
     * @param secretName the secretName value to set.
     * @return the ApiKVReferenceInner object itself.
     */
    public ApiKVReferenceInner withSecretName(String secretName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withSecretName(secretName);
        return this;
    }

    /**
     * Get the secretVersion property: The secretVersion property.
     * 
     * @return the secretVersion value.
     */
    public String secretVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().secretVersion();
    }

    /**
     * Set the secretVersion property: The secretVersion property.
     * 
     * @param secretVersion the secretVersion value to set.
     * @return the ApiKVReferenceInner object itself.
     */
    public ApiKVReferenceInner withSecretVersion(String secretVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withSecretVersion(secretVersion);
        return this;
    }

    /**
     * Get the identityType property: Managed service identity.
     * 
     * @return the identityType value.
     */
    public ManagedServiceIdentity identityType() {
        return this.innerProperties() == null ? null : this.innerProperties().identityType();
    }

    /**
     * Set the identityType property: Managed service identity.
     * 
     * @param identityType the identityType value to set.
     * @return the ApiKVReferenceInner object itself.
     */
    public ApiKVReferenceInner withIdentityType(ManagedServiceIdentity identityType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withIdentityType(identityType);
        return this;
    }

    /**
     * Get the details property: The details property.
     * 
     * @return the details value.
     */
    public String details() {
        return this.innerProperties() == null ? null : this.innerProperties().details();
    }

    /**
     * Set the details property: The details property.
     * 
     * @param details the details value to set.
     * @return the ApiKVReferenceInner object itself.
     */
    public ApiKVReferenceInner withDetails(String details) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withDetails(details);
        return this;
    }

    /**
     * Get the source property: The source property.
     * 
     * @return the source value.
     */
    public ConfigReferenceSource source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    /**
     * Set the source property: The source property.
     * 
     * @param source the source value to set.
     * @return the ApiKVReferenceInner object itself.
     */
    public ApiKVReferenceInner withSource(ConfigReferenceSource source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    /**
     * Get the activeVersion property: The activeVersion property.
     * 
     * @return the activeVersion value.
     */
    public String activeVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().activeVersion();
    }

    /**
     * Set the activeVersion property: The activeVersion property.
     * 
     * @param activeVersion the activeVersion value to set.
     * @return the ApiKVReferenceInner object itself.
     */
    public ApiKVReferenceInner withActiveVersion(String activeVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withActiveVersion(activeVersion);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiKVReferenceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiKVReferenceInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiKVReferenceInner.
     */
    public static ApiKVReferenceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiKVReferenceInner deserializedApiKVReferenceInner = new ApiKVReferenceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApiKVReferenceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedApiKVReferenceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApiKVReferenceInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedApiKVReferenceInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedApiKVReferenceInner.innerProperties = ApiKVReferenceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiKVReferenceInner;
        });
    }
}
