// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.VirtualIpMapping;
import java.io.IOException;
import java.util.List;

/**
 * Describes main public IP address and any extra virtual IPs.
 */
@Fluent
public final class AddressResponseInner extends ProxyOnlyResource {
    /*
     * AddressResponse resource specific properties
     */
    private AddressResponseProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of AddressResponseInner class.
     */
    public AddressResponseInner() {
    }

    /**
     * Get the innerProperties property: AddressResponse resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private AddressResponseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AddressResponseInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the serviceIpAddress property: Main public virtual IP.
     * 
     * @return the serviceIpAddress value.
     */
    public String serviceIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceIpAddress();
    }

    /**
     * Set the serviceIpAddress property: Main public virtual IP.
     * 
     * @param serviceIpAddress the serviceIpAddress value to set.
     * @return the AddressResponseInner object itself.
     */
    public AddressResponseInner withServiceIpAddress(String serviceIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AddressResponseProperties();
        }
        this.innerProperties().withServiceIpAddress(serviceIpAddress);
        return this;
    }

    /**
     * Get the internalIpAddress property: Virtual Network internal IP address of the App Service Environment if it is
     * in internal load-balancing mode.
     * 
     * @return the internalIpAddress value.
     */
    public String internalIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().internalIpAddress();
    }

    /**
     * Set the internalIpAddress property: Virtual Network internal IP address of the App Service Environment if it is
     * in internal load-balancing mode.
     * 
     * @param internalIpAddress the internalIpAddress value to set.
     * @return the AddressResponseInner object itself.
     */
    public AddressResponseInner withInternalIpAddress(String internalIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AddressResponseProperties();
        }
        this.innerProperties().withInternalIpAddress(internalIpAddress);
        return this;
    }

    /**
     * Get the outboundIpAddresses property: IP addresses appearing on outbound connections.
     * 
     * @return the outboundIpAddresses value.
     */
    public List<String> outboundIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundIpAddresses();
    }

    /**
     * Set the outboundIpAddresses property: IP addresses appearing on outbound connections.
     * 
     * @param outboundIpAddresses the outboundIpAddresses value to set.
     * @return the AddressResponseInner object itself.
     */
    public AddressResponseInner withOutboundIpAddresses(List<String> outboundIpAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AddressResponseProperties();
        }
        this.innerProperties().withOutboundIpAddresses(outboundIpAddresses);
        return this;
    }

    /**
     * Get the vipMappings property: Additional virtual IPs.
     * 
     * @return the vipMappings value.
     */
    public List<VirtualIpMapping> vipMappings() {
        return this.innerProperties() == null ? null : this.innerProperties().vipMappings();
    }

    /**
     * Set the vipMappings property: Additional virtual IPs.
     * 
     * @param vipMappings the vipMappings value to set.
     * @return the AddressResponseInner object itself.
     */
    public AddressResponseInner withVipMappings(List<VirtualIpMapping> vipMappings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AddressResponseProperties();
        }
        this.innerProperties().withVipMappings(vipMappings);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AddressResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AddressResponseInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AddressResponseInner.
     */
    public static AddressResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AddressResponseInner deserializedAddressResponseInner = new AddressResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAddressResponseInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAddressResponseInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAddressResponseInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedAddressResponseInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedAddressResponseInner.innerProperties = AddressResponseProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAddressResponseInner;
        });
    }
}
