/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.VnetParametersProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class VnetParameters
extends ProxyOnlyResource {
    private VnetParametersProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private VnetParametersProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public VnetParameters withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String vnetResourceGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetResourceGroup();
    }

    public VnetParameters withVnetResourceGroup(String vnetResourceGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetParametersProperties();
        }
        this.innerProperties().withVnetResourceGroup(vnetResourceGroup);
        return this;
    }

    public String vnetName() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetName();
    }

    public VnetParameters withVnetName(String vnetName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetParametersProperties();
        }
        this.innerProperties().withVnetName(vnetName);
        return this;
    }

    public String vnetSubnetName() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetSubnetName();
    }

    public VnetParameters withVnetSubnetName(String vnetSubnetName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetParametersProperties();
        }
        this.innerProperties().withVnetSubnetName(vnetSubnetName);
        return this;
    }

    public String subnetResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetResourceId();
    }

    public VnetParameters withSubnetResourceId(String subnetResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetParametersProperties();
        }
        this.innerProperties().withSubnetResourceId(subnetResourceId);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VnetParameters fromJson(JsonReader jsonReader) throws IOException {
        return (VnetParameters)((Object)jsonReader.readObject(reader -> {
            VnetParameters deserializedVnetParameters = new VnetParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVnetParameters.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVnetParameters.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVnetParameters.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedVnetParameters.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVnetParameters.innerProperties = VnetParametersProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVnetParameters;
        }));
    }
}

