/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.UserProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class UserInner
extends ProxyOnlyResource {
    private UserProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private UserProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public UserInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String publishingUsername() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingUsername();
    }

    public UserInner withPublishingUsername(String publishingUsername) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserProperties();
        }
        this.innerProperties().withPublishingUsername(publishingUsername);
        return this;
    }

    public String publishingPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingPassword();
    }

    public UserInner withPublishingPassword(String publishingPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserProperties();
        }
        this.innerProperties().withPublishingPassword(publishingPassword);
        return this;
    }

    public String publishingPasswordHash() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingPasswordHash();
    }

    public UserInner withPublishingPasswordHash(String publishingPasswordHash) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserProperties();
        }
        this.innerProperties().withPublishingPasswordHash(publishingPasswordHash);
        return this;
    }

    public String publishingPasswordHashSalt() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingPasswordHashSalt();
    }

    public UserInner withPublishingPasswordHashSalt(String publishingPasswordHashSalt) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserProperties();
        }
        this.innerProperties().withPublishingPasswordHashSalt(publishingPasswordHashSalt);
        return this;
    }

    public String scmUri() {
        return this.innerProperties() == null ? null : this.innerProperties().scmUri();
    }

    public UserInner withScmUri(String scmUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserProperties();
        }
        this.innerProperties().withScmUri(scmUri);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static UserInner fromJson(JsonReader jsonReader) throws IOException {
        return (UserInner)((Object)jsonReader.readObject(reader -> {
            UserInner deserializedUserInner = new UserInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedUserInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedUserInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedUserInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedUserInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedUserInner.innerProperties = UserProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserInner;
        }));
    }
}

