/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigInner;
import com.azure.resourcemanager.appservice.models.ClientCertMode;
import com.azure.resourcemanager.appservice.models.CloningInfo;
import com.azure.resourcemanager.appservice.models.DaprConfig;
import com.azure.resourcemanager.appservice.models.FunctionAppConfig;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.HostnameSslState;
import com.azure.resourcemanager.appservice.models.RedundancyMode;
import com.azure.resourcemanager.appservice.models.ResourceConfig;
import com.azure.resourcemanager.appservice.models.SiteAvailabilityState;
import com.azure.resourcemanager.appservice.models.SiteDnsConfig;
import com.azure.resourcemanager.appservice.models.SlotSwapStatus;
import com.azure.resourcemanager.appservice.models.UsageState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;

public final class SitePropertiesInner
implements JsonSerializable<SitePropertiesInner> {
    private String state;
    private List<String> hostNames;
    private String repositorySiteName;
    private UsageState usageState;
    private Boolean enabled;
    private List<String> enabledHostNames;
    private SiteAvailabilityState availabilityState;
    private List<HostnameSslState> hostnameSslStates;
    private String serverFarmId;
    private Boolean reserved;
    private Boolean isXenon;
    private Boolean hyperV;
    private OffsetDateTime lastModifiedTimeUtc;
    private SiteDnsConfig dnsConfiguration;
    private Boolean vnetRouteAllEnabled;
    private Boolean vnetImagePullEnabled;
    private Boolean vnetContentShareEnabled;
    private Boolean vnetBackupRestoreEnabled;
    private SiteConfigInner siteConfig;
    private FunctionAppConfig functionAppConfig;
    private DaprConfig daprConfig;
    private String workloadProfileName;
    private ResourceConfig resourceConfig;
    private List<String> trafficManagerHostNames;
    private Boolean scmSiteAlsoStopped;
    private String targetSwapSlot;
    private HostingEnvironmentProfile hostingEnvironmentProfile;
    private Boolean clientAffinityEnabled;
    private Boolean clientCertEnabled;
    private ClientCertMode clientCertMode;
    private String clientCertExclusionPaths;
    private Boolean hostNamesDisabled;
    private String customDomainVerificationId;
    private String outboundIpAddresses;
    private String possibleOutboundIpAddresses;
    private Integer containerSize;
    private Integer dailyMemoryTimeQuota;
    private OffsetDateTime suspendedTill;
    private Integer maxNumberOfWorkers;
    private CloningInfo cloningInfo;
    private String resourceGroup;
    private Boolean isDefaultContainer;
    private String defaultHostname;
    private SlotSwapStatus slotSwapStatus;
    private Boolean httpsOnly;
    private RedundancyMode redundancyMode;
    private UUID inProgressOperationId;
    private String publicNetworkAccess;
    private Boolean storageAccountRequired;
    private String keyVaultReferenceIdentity;
    private String virtualNetworkSubnetId;
    private String managedEnvironmentId;

    public String state() {
        return this.state;
    }

    public List<String> hostNames() {
        return this.hostNames;
    }

    public String repositorySiteName() {
        return this.repositorySiteName;
    }

    public UsageState usageState() {
        return this.usageState;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public SitePropertiesInner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> enabledHostNames() {
        return this.enabledHostNames;
    }

    public SiteAvailabilityState availabilityState() {
        return this.availabilityState;
    }

    public List<HostnameSslState> hostnameSslStates() {
        return this.hostnameSslStates;
    }

    public SitePropertiesInner withHostnameSslStates(List<HostnameSslState> hostnameSslStates) {
        this.hostnameSslStates = hostnameSslStates;
        return this;
    }

    public String serverFarmId() {
        return this.serverFarmId;
    }

    public SitePropertiesInner withServerFarmId(String serverFarmId) {
        this.serverFarmId = serverFarmId;
        return this;
    }

    public Boolean reserved() {
        return this.reserved;
    }

    public SitePropertiesInner withReserved(Boolean reserved) {
        this.reserved = reserved;
        return this;
    }

    public Boolean isXenon() {
        return this.isXenon;
    }

    public SitePropertiesInner withIsXenon(Boolean isXenon) {
        this.isXenon = isXenon;
        return this;
    }

    public Boolean hyperV() {
        return this.hyperV;
    }

    public SitePropertiesInner withHyperV(Boolean hyperV) {
        this.hyperV = hyperV;
        return this;
    }

    public OffsetDateTime lastModifiedTimeUtc() {
        return this.lastModifiedTimeUtc;
    }

    public SiteDnsConfig dnsConfiguration() {
        return this.dnsConfiguration;
    }

    public SitePropertiesInner withDnsConfiguration(SiteDnsConfig dnsConfiguration) {
        this.dnsConfiguration = dnsConfiguration;
        return this;
    }

    public Boolean vnetRouteAllEnabled() {
        return this.vnetRouteAllEnabled;
    }

    public SitePropertiesInner withVnetRouteAllEnabled(Boolean vnetRouteAllEnabled) {
        this.vnetRouteAllEnabled = vnetRouteAllEnabled;
        return this;
    }

    public Boolean vnetImagePullEnabled() {
        return this.vnetImagePullEnabled;
    }

    public SitePropertiesInner withVnetImagePullEnabled(Boolean vnetImagePullEnabled) {
        this.vnetImagePullEnabled = vnetImagePullEnabled;
        return this;
    }

    public Boolean vnetContentShareEnabled() {
        return this.vnetContentShareEnabled;
    }

    public SitePropertiesInner withVnetContentShareEnabled(Boolean vnetContentShareEnabled) {
        this.vnetContentShareEnabled = vnetContentShareEnabled;
        return this;
    }

    public Boolean vnetBackupRestoreEnabled() {
        return this.vnetBackupRestoreEnabled;
    }

    public SitePropertiesInner withVnetBackupRestoreEnabled(Boolean vnetBackupRestoreEnabled) {
        this.vnetBackupRestoreEnabled = vnetBackupRestoreEnabled;
        return this;
    }

    public SiteConfigInner siteConfig() {
        return this.siteConfig;
    }

    public SitePropertiesInner withSiteConfig(SiteConfigInner siteConfig) {
        this.siteConfig = siteConfig;
        return this;
    }

    public FunctionAppConfig functionAppConfig() {
        return this.functionAppConfig;
    }

    public SitePropertiesInner withFunctionAppConfig(FunctionAppConfig functionAppConfig) {
        this.functionAppConfig = functionAppConfig;
        return this;
    }

    public DaprConfig daprConfig() {
        return this.daprConfig;
    }

    public SitePropertiesInner withDaprConfig(DaprConfig daprConfig) {
        this.daprConfig = daprConfig;
        return this;
    }

    public String workloadProfileName() {
        return this.workloadProfileName;
    }

    public SitePropertiesInner withWorkloadProfileName(String workloadProfileName) {
        this.workloadProfileName = workloadProfileName;
        return this;
    }

    public ResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public SitePropertiesInner withResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
        return this;
    }

    public List<String> trafficManagerHostNames() {
        return this.trafficManagerHostNames;
    }

    public Boolean scmSiteAlsoStopped() {
        return this.scmSiteAlsoStopped;
    }

    public SitePropertiesInner withScmSiteAlsoStopped(Boolean scmSiteAlsoStopped) {
        this.scmSiteAlsoStopped = scmSiteAlsoStopped;
        return this;
    }

    public String targetSwapSlot() {
        return this.targetSwapSlot;
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.hostingEnvironmentProfile;
    }

    public SitePropertiesInner withHostingEnvironmentProfile(HostingEnvironmentProfile hostingEnvironmentProfile) {
        this.hostingEnvironmentProfile = hostingEnvironmentProfile;
        return this;
    }

    public Boolean clientAffinityEnabled() {
        return this.clientAffinityEnabled;
    }

    public SitePropertiesInner withClientAffinityEnabled(Boolean clientAffinityEnabled) {
        this.clientAffinityEnabled = clientAffinityEnabled;
        return this;
    }

    public Boolean clientCertEnabled() {
        return this.clientCertEnabled;
    }

    public SitePropertiesInner withClientCertEnabled(Boolean clientCertEnabled) {
        this.clientCertEnabled = clientCertEnabled;
        return this;
    }

    public ClientCertMode clientCertMode() {
        return this.clientCertMode;
    }

    public SitePropertiesInner withClientCertMode(ClientCertMode clientCertMode) {
        this.clientCertMode = clientCertMode;
        return this;
    }

    public String clientCertExclusionPaths() {
        return this.clientCertExclusionPaths;
    }

    public SitePropertiesInner withClientCertExclusionPaths(String clientCertExclusionPaths) {
        this.clientCertExclusionPaths = clientCertExclusionPaths;
        return this;
    }

    public Boolean hostNamesDisabled() {
        return this.hostNamesDisabled;
    }

    public SitePropertiesInner withHostNamesDisabled(Boolean hostNamesDisabled) {
        this.hostNamesDisabled = hostNamesDisabled;
        return this;
    }

    public String customDomainVerificationId() {
        return this.customDomainVerificationId;
    }

    public SitePropertiesInner withCustomDomainVerificationId(String customDomainVerificationId) {
        this.customDomainVerificationId = customDomainVerificationId;
        return this;
    }

    public String outboundIpAddresses() {
        return this.outboundIpAddresses;
    }

    public String possibleOutboundIpAddresses() {
        return this.possibleOutboundIpAddresses;
    }

    public Integer containerSize() {
        return this.containerSize;
    }

    public SitePropertiesInner withContainerSize(Integer containerSize) {
        this.containerSize = containerSize;
        return this;
    }

    public Integer dailyMemoryTimeQuota() {
        return this.dailyMemoryTimeQuota;
    }

    public SitePropertiesInner withDailyMemoryTimeQuota(Integer dailyMemoryTimeQuota) {
        this.dailyMemoryTimeQuota = dailyMemoryTimeQuota;
        return this;
    }

    public OffsetDateTime suspendedTill() {
        return this.suspendedTill;
    }

    public Integer maxNumberOfWorkers() {
        return this.maxNumberOfWorkers;
    }

    public CloningInfo cloningInfo() {
        return this.cloningInfo;
    }

    public SitePropertiesInner withCloningInfo(CloningInfo cloningInfo) {
        this.cloningInfo = cloningInfo;
        return this;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public Boolean isDefaultContainer() {
        return this.isDefaultContainer;
    }

    public String defaultHostname() {
        return this.defaultHostname;
    }

    public SlotSwapStatus slotSwapStatus() {
        return this.slotSwapStatus;
    }

    public Boolean httpsOnly() {
        return this.httpsOnly;
    }

    public SitePropertiesInner withHttpsOnly(Boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
        return this;
    }

    public RedundancyMode redundancyMode() {
        return this.redundancyMode;
    }

    public SitePropertiesInner withRedundancyMode(RedundancyMode redundancyMode) {
        this.redundancyMode = redundancyMode;
        return this;
    }

    public UUID inProgressOperationId() {
        return this.inProgressOperationId;
    }

    public String publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public SitePropertiesInner withPublicNetworkAccess(String publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Boolean storageAccountRequired() {
        return this.storageAccountRequired;
    }

    public SitePropertiesInner withStorageAccountRequired(Boolean storageAccountRequired) {
        this.storageAccountRequired = storageAccountRequired;
        return this;
    }

    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    public SitePropertiesInner withKeyVaultReferenceIdentity(String keyVaultReferenceIdentity) {
        this.keyVaultReferenceIdentity = keyVaultReferenceIdentity;
        return this;
    }

    public String virtualNetworkSubnetId() {
        return this.virtualNetworkSubnetId;
    }

    public SitePropertiesInner withVirtualNetworkSubnetId(String virtualNetworkSubnetId) {
        this.virtualNetworkSubnetId = virtualNetworkSubnetId;
        return this;
    }

    public String managedEnvironmentId() {
        return this.managedEnvironmentId;
    }

    public SitePropertiesInner withManagedEnvironmentId(String managedEnvironmentId) {
        this.managedEnvironmentId = managedEnvironmentId;
        return this;
    }

    public void validate() {
        if (this.hostnameSslStates() != null) {
            this.hostnameSslStates().forEach(e -> e.validate());
        }
        if (this.dnsConfiguration() != null) {
            this.dnsConfiguration().validate();
        }
        if (this.siteConfig() != null) {
            this.siteConfig().validate();
        }
        if (this.functionAppConfig() != null) {
            this.functionAppConfig().validate();
        }
        if (this.daprConfig() != null) {
            this.daprConfig().validate();
        }
        if (this.resourceConfig() != null) {
            this.resourceConfig().validate();
        }
        if (this.hostingEnvironmentProfile() != null) {
            this.hostingEnvironmentProfile().validate();
        }
        if (this.cloningInfo() != null) {
            this.cloningInfo().validate();
        }
        if (this.slotSwapStatus() != null) {
            this.slotSwapStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("hostNameSslStates", this.hostnameSslStates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("serverFarmId", this.serverFarmId);
        jsonWriter.writeBooleanField("reserved", this.reserved);
        jsonWriter.writeBooleanField("isXenon", this.isXenon);
        jsonWriter.writeBooleanField("hyperV", this.hyperV);
        jsonWriter.writeJsonField("dnsConfiguration", (JsonSerializable)this.dnsConfiguration);
        jsonWriter.writeBooleanField("vnetRouteAllEnabled", this.vnetRouteAllEnabled);
        jsonWriter.writeBooleanField("vnetImagePullEnabled", this.vnetImagePullEnabled);
        jsonWriter.writeBooleanField("vnetContentShareEnabled", this.vnetContentShareEnabled);
        jsonWriter.writeBooleanField("vnetBackupRestoreEnabled", this.vnetBackupRestoreEnabled);
        jsonWriter.writeJsonField("siteConfig", (JsonSerializable)this.siteConfig);
        jsonWriter.writeJsonField("functionAppConfig", (JsonSerializable)this.functionAppConfig);
        jsonWriter.writeJsonField("daprConfig", (JsonSerializable)this.daprConfig);
        jsonWriter.writeStringField("workloadProfileName", this.workloadProfileName);
        jsonWriter.writeJsonField("resourceConfig", (JsonSerializable)this.resourceConfig);
        jsonWriter.writeBooleanField("scmSiteAlsoStopped", this.scmSiteAlsoStopped);
        jsonWriter.writeJsonField("hostingEnvironmentProfile", (JsonSerializable)this.hostingEnvironmentProfile);
        jsonWriter.writeBooleanField("clientAffinityEnabled", this.clientAffinityEnabled);
        jsonWriter.writeBooleanField("clientCertEnabled", this.clientCertEnabled);
        jsonWriter.writeStringField("clientCertMode", this.clientCertMode == null ? null : this.clientCertMode.toString());
        jsonWriter.writeStringField("clientCertExclusionPaths", this.clientCertExclusionPaths);
        jsonWriter.writeBooleanField("hostNamesDisabled", this.hostNamesDisabled);
        jsonWriter.writeStringField("customDomainVerificationId", this.customDomainVerificationId);
        jsonWriter.writeNumberField("containerSize", (Number)this.containerSize);
        jsonWriter.writeNumberField("dailyMemoryTimeQuota", (Number)this.dailyMemoryTimeQuota);
        jsonWriter.writeJsonField("cloningInfo", (JsonSerializable)this.cloningInfo);
        jsonWriter.writeBooleanField("httpsOnly", this.httpsOnly);
        jsonWriter.writeStringField("redundancyMode", this.redundancyMode == null ? null : this.redundancyMode.toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess);
        jsonWriter.writeBooleanField("storageAccountRequired", this.storageAccountRequired);
        jsonWriter.writeStringField("keyVaultReferenceIdentity", this.keyVaultReferenceIdentity);
        jsonWriter.writeStringField("virtualNetworkSubnetId", this.virtualNetworkSubnetId);
        jsonWriter.writeStringField("managedEnvironmentId", this.managedEnvironmentId);
        return jsonWriter.writeEndObject();
    }

    public static SitePropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (SitePropertiesInner)jsonReader.readObject(reader -> {
            SitePropertiesInner deserializedSitePropertiesInner = new SitePropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedSitePropertiesInner.state = reader.getString();
                    continue;
                }
                if ("hostNames".equals(fieldName)) {
                    List hostNames;
                    deserializedSitePropertiesInner.hostNames = hostNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("repositorySiteName".equals(fieldName)) {
                    deserializedSitePropertiesInner.repositorySiteName = reader.getString();
                    continue;
                }
                if ("usageState".equals(fieldName)) {
                    deserializedSitePropertiesInner.usageState = UsageState.fromString(reader.getString());
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedSitePropertiesInner.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enabledHostNames".equals(fieldName)) {
                    List enabledHostNames;
                    deserializedSitePropertiesInner.enabledHostNames = enabledHostNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("availabilityState".equals(fieldName)) {
                    deserializedSitePropertiesInner.availabilityState = SiteAvailabilityState.fromString(reader.getString());
                    continue;
                }
                if ("hostNameSslStates".equals(fieldName)) {
                    List hostnameSslStates;
                    deserializedSitePropertiesInner.hostnameSslStates = hostnameSslStates = reader.readArray(reader1 -> HostnameSslState.fromJson(reader1));
                    continue;
                }
                if ("serverFarmId".equals(fieldName)) {
                    deserializedSitePropertiesInner.serverFarmId = reader.getString();
                    continue;
                }
                if ("reserved".equals(fieldName)) {
                    deserializedSitePropertiesInner.reserved = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isXenon".equals(fieldName)) {
                    deserializedSitePropertiesInner.isXenon = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hyperV".equals(fieldName)) {
                    deserializedSitePropertiesInner.hyperV = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastModifiedTimeUtc".equals(fieldName)) {
                    deserializedSitePropertiesInner.lastModifiedTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("dnsConfiguration".equals(fieldName)) {
                    deserializedSitePropertiesInner.dnsConfiguration = SiteDnsConfig.fromJson(reader);
                    continue;
                }
                if ("vnetRouteAllEnabled".equals(fieldName)) {
                    deserializedSitePropertiesInner.vnetRouteAllEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("vnetImagePullEnabled".equals(fieldName)) {
                    deserializedSitePropertiesInner.vnetImagePullEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("vnetContentShareEnabled".equals(fieldName)) {
                    deserializedSitePropertiesInner.vnetContentShareEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("vnetBackupRestoreEnabled".equals(fieldName)) {
                    deserializedSitePropertiesInner.vnetBackupRestoreEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("siteConfig".equals(fieldName)) {
                    deserializedSitePropertiesInner.siteConfig = SiteConfigInner.fromJson(reader);
                    continue;
                }
                if ("functionAppConfig".equals(fieldName)) {
                    deserializedSitePropertiesInner.functionAppConfig = FunctionAppConfig.fromJson(reader);
                    continue;
                }
                if ("daprConfig".equals(fieldName)) {
                    deserializedSitePropertiesInner.daprConfig = DaprConfig.fromJson(reader);
                    continue;
                }
                if ("workloadProfileName".equals(fieldName)) {
                    deserializedSitePropertiesInner.workloadProfileName = reader.getString();
                    continue;
                }
                if ("resourceConfig".equals(fieldName)) {
                    deserializedSitePropertiesInner.resourceConfig = ResourceConfig.fromJson(reader);
                    continue;
                }
                if ("trafficManagerHostNames".equals(fieldName)) {
                    List trafficManagerHostNames;
                    deserializedSitePropertiesInner.trafficManagerHostNames = trafficManagerHostNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("scmSiteAlsoStopped".equals(fieldName)) {
                    deserializedSitePropertiesInner.scmSiteAlsoStopped = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("targetSwapSlot".equals(fieldName)) {
                    deserializedSitePropertiesInner.targetSwapSlot = reader.getString();
                    continue;
                }
                if ("hostingEnvironmentProfile".equals(fieldName)) {
                    deserializedSitePropertiesInner.hostingEnvironmentProfile = HostingEnvironmentProfile.fromJson(reader);
                    continue;
                }
                if ("clientAffinityEnabled".equals(fieldName)) {
                    deserializedSitePropertiesInner.clientAffinityEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("clientCertEnabled".equals(fieldName)) {
                    deserializedSitePropertiesInner.clientCertEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("clientCertMode".equals(fieldName)) {
                    deserializedSitePropertiesInner.clientCertMode = ClientCertMode.fromString(reader.getString());
                    continue;
                }
                if ("clientCertExclusionPaths".equals(fieldName)) {
                    deserializedSitePropertiesInner.clientCertExclusionPaths = reader.getString();
                    continue;
                }
                if ("hostNamesDisabled".equals(fieldName)) {
                    deserializedSitePropertiesInner.hostNamesDisabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("customDomainVerificationId".equals(fieldName)) {
                    deserializedSitePropertiesInner.customDomainVerificationId = reader.getString();
                    continue;
                }
                if ("outboundIpAddresses".equals(fieldName)) {
                    deserializedSitePropertiesInner.outboundIpAddresses = reader.getString();
                    continue;
                }
                if ("possibleOutboundIpAddresses".equals(fieldName)) {
                    deserializedSitePropertiesInner.possibleOutboundIpAddresses = reader.getString();
                    continue;
                }
                if ("containerSize".equals(fieldName)) {
                    deserializedSitePropertiesInner.containerSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dailyMemoryTimeQuota".equals(fieldName)) {
                    deserializedSitePropertiesInner.dailyMemoryTimeQuota = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("suspendedTill".equals(fieldName)) {
                    deserializedSitePropertiesInner.suspendedTill = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("maxNumberOfWorkers".equals(fieldName)) {
                    deserializedSitePropertiesInner.maxNumberOfWorkers = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cloningInfo".equals(fieldName)) {
                    deserializedSitePropertiesInner.cloningInfo = CloningInfo.fromJson(reader);
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedSitePropertiesInner.resourceGroup = reader.getString();
                    continue;
                }
                if ("isDefaultContainer".equals(fieldName)) {
                    deserializedSitePropertiesInner.isDefaultContainer = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultHostName".equals(fieldName)) {
                    deserializedSitePropertiesInner.defaultHostname = reader.getString();
                    continue;
                }
                if ("slotSwapStatus".equals(fieldName)) {
                    deserializedSitePropertiesInner.slotSwapStatus = SlotSwapStatus.fromJson(reader);
                    continue;
                }
                if ("httpsOnly".equals(fieldName)) {
                    deserializedSitePropertiesInner.httpsOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("redundancyMode".equals(fieldName)) {
                    deserializedSitePropertiesInner.redundancyMode = RedundancyMode.fromString(reader.getString());
                    continue;
                }
                if ("inProgressOperationId".equals(fieldName)) {
                    deserializedSitePropertiesInner.inProgressOperationId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedSitePropertiesInner.publicNetworkAccess = reader.getString();
                    continue;
                }
                if ("storageAccountRequired".equals(fieldName)) {
                    deserializedSitePropertiesInner.storageAccountRequired = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("keyVaultReferenceIdentity".equals(fieldName)) {
                    deserializedSitePropertiesInner.keyVaultReferenceIdentity = reader.getString();
                    continue;
                }
                if ("virtualNetworkSubnetId".equals(fieldName)) {
                    deserializedSitePropertiesInner.virtualNetworkSubnetId = reader.getString();
                    continue;
                }
                if ("managedEnvironmentId".equals(fieldName)) {
                    deserializedSitePropertiesInner.managedEnvironmentId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSitePropertiesInner;
        });
    }
}

