// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Trigger based on request execution time.
 */
@Fluent
public final class SlowRequestsBasedTrigger implements JsonSerializable<SlowRequestsBasedTrigger> {
    /*
     * Time taken.
     */
    private String timeTaken;

    /*
     * Request Path.
     */
    private String path;

    /*
     * Request Count.
     */
    private Integer count;

    /*
     * Time interval.
     */
    private String timeInterval;

    /**
     * Creates an instance of SlowRequestsBasedTrigger class.
     */
    public SlowRequestsBasedTrigger() {
    }

    /**
     * Get the timeTaken property: Time taken.
     * 
     * @return the timeTaken value.
     */
    public String timeTaken() {
        return this.timeTaken;
    }

    /**
     * Set the timeTaken property: Time taken.
     * 
     * @param timeTaken the timeTaken value to set.
     * @return the SlowRequestsBasedTrigger object itself.
     */
    public SlowRequestsBasedTrigger withTimeTaken(String timeTaken) {
        this.timeTaken = timeTaken;
        return this;
    }

    /**
     * Get the path property: Request Path.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: Request Path.
     * 
     * @param path the path value to set.
     * @return the SlowRequestsBasedTrigger object itself.
     */
    public SlowRequestsBasedTrigger withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the count property: Request Count.
     * 
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count property: Request Count.
     * 
     * @param count the count value to set.
     * @return the SlowRequestsBasedTrigger object itself.
     */
    public SlowRequestsBasedTrigger withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Get the timeInterval property: Time interval.
     * 
     * @return the timeInterval value.
     */
    public String timeInterval() {
        return this.timeInterval;
    }

    /**
     * Set the timeInterval property: Time interval.
     * 
     * @param timeInterval the timeInterval value to set.
     * @return the SlowRequestsBasedTrigger object itself.
     */
    public SlowRequestsBasedTrigger withTimeInterval(String timeInterval) {
        this.timeInterval = timeInterval;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeTaken", this.timeTaken);
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeNumberField("count", this.count);
        jsonWriter.writeStringField("timeInterval", this.timeInterval);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SlowRequestsBasedTrigger from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SlowRequestsBasedTrigger if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SlowRequestsBasedTrigger.
     */
    public static SlowRequestsBasedTrigger fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SlowRequestsBasedTrigger deserializedSlowRequestsBasedTrigger = new SlowRequestsBasedTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timeTaken".equals(fieldName)) {
                    deserializedSlowRequestsBasedTrigger.timeTaken = reader.getString();
                } else if ("path".equals(fieldName)) {
                    deserializedSlowRequestsBasedTrigger.path = reader.getString();
                } else if ("count".equals(fieldName)) {
                    deserializedSlowRequestsBasedTrigger.count = reader.getNullable(JsonReader::getInt);
                } else if ("timeInterval".equals(fieldName)) {
                    deserializedSlowRequestsBasedTrigger.timeInterval = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSlowRequestsBasedTrigger;
        });
    }
}
