// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Application logs to file system configuration.
 */
@Fluent
public final class FileSystemApplicationLogsConfig implements JsonSerializable<FileSystemApplicationLogsConfig> {
    /*
     * Log level.
     */
    private LogLevel level;

    /**
     * Creates an instance of FileSystemApplicationLogsConfig class.
     */
    public FileSystemApplicationLogsConfig() {
    }

    /**
     * Get the level property: Log level.
     * 
     * @return the level value.
     */
    public LogLevel level() {
        return this.level;
    }

    /**
     * Set the level property: Log level.
     * 
     * @param level the level value to set.
     * @return the FileSystemApplicationLogsConfig object itself.
     */
    public FileSystemApplicationLogsConfig withLevel(LogLevel level) {
        this.level = level;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileSystemApplicationLogsConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileSystemApplicationLogsConfig if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FileSystemApplicationLogsConfig.
     */
    public static FileSystemApplicationLogsConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileSystemApplicationLogsConfig deserializedFileSystemApplicationLogsConfig
                = new FileSystemApplicationLogsConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("level".equals(fieldName)) {
                    deserializedFileSystemApplicationLogsConfig.level = LogLevel.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFileSystemApplicationLogsConfig;
        });
    }
}
